/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import java.util.List;
import java.util.Set;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Tool;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.mule.tooling.messageflow.editor.InterruptibleCreationTool;
import org.mule.tooling.ui.internal.palette.core.PaletteContentFactory;
import org.mule.tooling.ui.internal.palette.view.SWTHelper;
import org.mule.tooling.ui.palette.PaletteManager;
import org.mule.tooling.ui.palette.core.ModulePaletteEntry;
import org.mule.tooling.ui.palette.core.NodeDefinitionPaletteEntry;
import org.mule.tooling.ui.palette.core.PaletteCategory;
import org.mule.tooling.ui.palette.utils.PaletteHelper;
import org.mule.tooling.ui.palette.view.EntityTemplateTransferDragSourceListener;
import org.mule.tooling.ui.palette.view.PaletteState;
import org.mule.tooling.ui.palette.view.PaletteStyledCellLabelProvider;

public class OperationsViewer
extends Viewer {
    private final TableViewer tableViewer;
    private EditDomain editDomain;
    private EntityTemplateTransferDragSourceListener dragListener;

    public OperationsViewer(Composite parent, int style, final PaletteState paletteState, final Runnable onMouseEnteredModule, final Runnable onMouseExitModulesList) {
        this.tableViewer = new TableViewer(parent, style);
        final Cursor originalCursor = this.tableViewer.getControl().getCursor();
        Cursor handCursor = Display.getDefault().getSystemCursor(21);
        this.tableViewer.getControl().setCursor(handCursor);
        PaletteStyledCellLabelProvider labelProvider = new PaletteStyledCellLabelProvider();
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.dragListener = new EntityTemplateTransferDragSourceListener(this.tableViewer, paletteState);
        this.tableViewer.addDragSupport(3, transfers, (DragSourceListener)this.dragListener);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.getControl().addListener(6, new Listener(){

            public void handleEvent(Event e) {
                if (paletteState.getSelectedEntry() != null && paletteState.getSelectedEntry().getId().equals("org.mule.tooling.local")) {
                    onMouseEnteredModule.run();
                }
            }
        });
        this.tableViewer.getControl().addListener(7, new Listener(){

            public void handleEvent(Event e) {
                onMouseExitModulesList.run();
            }
        });
        this.tableViewer.getTable().addMouseMoveListener(e -> {
            Point pt = new Point(e.x, e.y);
            ViewerCell item = this.tableViewer.getCell(pt);
            if (item == null) {
                return;
            }
            Object element = item.getElement();
            if (element instanceof PaletteCategory || PaletteContentFactory.isDummyEntry(element)) {
                this.tableViewer.getControl().setCursor(originalCursor);
            } else {
                this.tableViewer.getControl().setCursor(handCursor);
            }
        });
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                OperationsViewer.this.editDomain.setActiveTool(OperationsViewer.this.editDomain.getDefaultTool());
                OperationsViewer.this.tableViewer.getControl().setCursor(originalCursor);
                Point pt = new Point(e.x, e.y);
                ViewerCell item = OperationsViewer.this.tableViewer.getCell(pt);
                if (item == null) {
                    return;
                }
                Object element = item.getElement();
                if (element instanceof PaletteCategory) {
                    if ((e.stateMask & SWT.MOD3) == SWT.MOD3) {
                        paletteState.toggleAllCategories();
                    } else {
                        paletteState.toggleCategory((PaletteCategory)element);
                    }
                    OperationsViewer.this.tableViewer.refresh();
                } else if (element instanceof NodeDefinitionPaletteEntry) {
                    NodeDefinitionPaletteEntry entry = (NodeDefinitionPaletteEntry)element;
                    Set<String> modulesIds = PaletteHelper.getModuleIdsContaining(entry);
                    CreationFactory template = PaletteHelper.createFactory(entry.getNodeDefinition(), modulesIds);
                    InterruptibleCreationTool.getInstance().setFactory(template);
                    OperationsViewer.this.editDomain.setActiveTool((Tool)InterruptibleCreationTool.getInstance());
                }
            }
        });
        this.tableViewer.getControl().addKeyListener(KeyListener.keyPressedAdapter(e -> {
            Object element = this.tableViewer.getStructuredSelection().getFirstElement();
            if (element == null || !(element instanceof PaletteCategory)) {
                return;
            }
            PaletteCategory category = (PaletteCategory)element;
            if (e.keyCode == 13 || e.keyCode == 10 || e.keyCode == 32) {
                paletteState.toggleCategory(category);
            }
            if (e.keyCode == 0x1000003) {
                paletteState.setCategoryCollapsed(category);
            }
            if (e.keyCode == 0x1000004) {
                paletteState.setCategoryExpanded(category);
            }
            this.tableViewer.refresh();
        }));
        this.tableViewer.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 20;
            }
        });
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    OperationsViewer.this.editDomain.setActiveTool(OperationsViewer.this.editDomain.getDefaultTool());
                }
            }
        });
        this.tableViewer.getControl().addFocusListener(FocusListener.focusGainedAdapter(e -> {
            if (this.tableViewer.getSelection().isEmpty()) {
                this.focusFirstItem();
            }
        }));
        ViewerFilter filterViewer = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (paletteState.getSearchFilter() == "") {
                    if (element instanceof NodeDefinitionPaletteEntry) {
                        for (PaletteCategory category : paletteState.getCollapsedCategories()) {
                            if (!category.getEntries().contains(element)) continue;
                            return false;
                        }
                        return true;
                    }
                    if (element instanceof ModulePaletteEntry) {
                        for (PaletteCategory category : paletteState.getCollapsedCategories()) {
                            if (!category.getEntries().contains(element)) continue;
                            return false;
                        }
                        return true;
                    }
                    if (element instanceof PaletteCategory) {
                        return true;
                    }
                    return PaletteContentFactory.isDummyEntry(element);
                }
                return true;
            }
        };
        this.tableViewer.addFilter(filterViewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.createMenu();
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.tableViewer.getControl());
    }

    public void createMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                Object object;
                if (OperationsViewer.this.tableViewer.getSelection().isEmpty()) {
                    return;
                }
                if (OperationsViewer.this.tableViewer.getSelection() instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)OperationsViewer.this.tableViewer.getSelection()).getFirstElement()) instanceof NodeDefinitionPaletteEntry) {
                    NodeDefinitionPaletteEntry node = (NodeDefinitionPaletteEntry)object;
                    OperationsViewer.createActions(manager, node);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getControl().setMenu(menu);
    }

    public static void createActions(IMenuManager manager, NodeDefinitionPaletteEntry node) {
        String id;
        List<String> favorites = PaletteManager.getFavorites();
        if (favorites.contains(id = node.getId())) {
            manager.add((IAction)new Action("Remove from favorites"){

                public void run() {
                    PaletteManager.removeFromFavorites(id);
                }
            });
        } else {
            manager.add((IAction)new Action("Add to favorites"){

                public void run() {
                    PaletteManager.addToFavorites(id);
                }
            });
        }
    }

    public Control getControl() {
        return this.tableViewer.getControl();
    }

    public Object getInput() {
        return this.tableViewer.getInput();
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void setInput(Object input) {
        this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        SWTHelper.clearSelectedRowIndexFieldValue(this.tableViewer.getTable());
        this.tableViewer.setInput(input);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.tableViewer.setSelection(selection, reveal);
    }

    public void setEditDomain(EditDomain editDomain) {
        this.editDomain = editDomain;
        this.dragListener.setEditDomain(editDomain);
    }

    private void focusFirstItem() {
        Object elementAt = this.tableViewer.getElementAt(0);
        if (elementAt != null) {
            this.tableViewer.getControl().setFocus();
            this.setSelection((ISelection)new StructuredSelection(elementAt), true);
        }
    }
}

