/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.ui.command.OpenManageModulesPropertyPage;
import org.mule.tooling.ui.palette.PaletteManager;
import org.mule.tooling.ui.palette.core.PaletteMainEntry;
import org.mule.tooling.ui.palette.view.DropSimpleDefinition;
import org.mule.tooling.ui.palette.view.PaletteInput;
import org.mule.tooling.ui.palette.view.PaletteStyledCellLabelProvider;

public class ModulesViewer
extends Viewer {
    private final TableViewer tableViewer;
    private PaletteInput input;

    public ModulesViewer(Composite parent, int style) {
        this.tableViewer = new TableViewer(parent, style);
        PaletteStyledCellLabelProvider labelProvider = new PaletteStyledCellLabelProvider();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.getTable().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 20;
            }
        });
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.tableViewer.addDropSupport(3, transfers, (DropTargetListener)new DropSimpleDefinition((Viewer)this.tableViewer));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.tableViewer.getControl());
        this.createMenu();
    }

    public Control getControl() {
        return this.tableViewer.getControl();
    }

    public boolean hasInput() {
        return this.input != null;
    }

    public Object getInput() {
        return this.input.getPaletteMainEntries();
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    public void setInput(Object input) {
        this.input = (PaletteInput)input;
        this.tableViewer.setInput(this.input.getPaletteMainEntries());
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.tableViewer.setSelection(selection, reveal);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void createMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(this.tableViewer.getControl());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                Object object;
                if (ModulesViewer.this.tableViewer.getSelection().isEmpty()) {
                    return;
                }
                if (ModulesViewer.this.tableViewer.getSelection() instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)ModulesViewer.this.tableViewer.getSelection()).getFirstElement()) instanceof PaletteMainEntry) {
                    PaletteMainEntry paletteEntry = (PaletteMainEntry)object;
                    if (paletteEntry.getId().equals("org.mule.tooling.favorites")) {
                        manager.add((IAction)new Action("Restore defaults"){

                            public void run() {
                                PaletteManager.restoreDefaults();
                            }
                        });
                    } else if (!paletteEntry.getId().equals("org.mule.tooling.core") && !paletteEntry.getId().equals("org.mule.tooling.local")) {
                        final IMuleProject muleProject = ModulesViewer.this.input.getMuleProject();
                        IMuleModuleManager moduleManager = muleProject.getModuleManager();
                        final Optional<ExternalContributionMuleModule> module = moduleManager.getExternalModules().stream().filter(x -> x.getId().equals(paletteEntry.getId())).findFirst();
                        module.ifPresent(extension -> {
                            IMuleApplicationProject applicationProject;
                            IMuleDomain domain;
                            Action removeAction = new Action("Remove module", (ExternalContributionMuleModule)extension, paletteEntry){
                                private final /* synthetic */ ExternalContributionMuleModule val$extension;
                                private final /* synthetic */ PaletteMainEntry val$paletteEntry;
                                {
                                    this.val$extension = externalContributionMuleModule;
                                    this.val$paletteEntry = paletteMainEntry;
                                    super($anonymous0);
                                }

                                public void run() {
                                    try {
                                        muleProject.removeMuleExtension(this.val$extension);
                                    }
                                    catch (CoreException e) {
                                        MuleCorePlugin.logError((String)("Unexpected error removing [" + this.val$paletteEntry.getId() + "]"), (Throwable)e);
                                    }
                                }
                            };
                            if (MuleProjectKind.APPLICATION.classifies(muleProject) && (domain = (applicationProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject)).getDomain()) != null && CoreUtils.isExternalContributionDefinedInProjectModel((ExternalContributionMuleModule)extension, (IMuleProjectModel)domain.getMuleProjectModel())) {
                                if (!domain.isExternal()) {
                                    removeAction = new Action("Manage modules from domain"){

                                        public void run() {
                                            module.ifPresent(extension -> {
                                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                                OpenManageModulesPropertyPage.openManageModulesPropertyPage((Shell)shell, (IProject)((IMuleDomainProject)domain).getProject(), (Object)1);
                                            });
                                        }
                                    };
                                } else {
                                    removeAction.setEnabled(false);
                                    removeAction.setText("Remove module (module defined in external domain)");
                                }
                            }
                            manager.add((IAction)removeAction);
                        });
                    }
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getControl().setMenu(menu);
    }
}

