/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.view;

import java.util.Set;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.ui.palette.NullCreationFactory;
import org.mule.tooling.ui.palette.core.ModulePaletteEntry;
import org.mule.tooling.ui.palette.core.NodeDefinitionPaletteEntry;
import org.mule.tooling.ui.palette.core.SearchResult;
import org.mule.tooling.ui.palette.utils.PaletteHelper;
import org.mule.tooling.ui.palette.view.PaletteState;

public class EntityTemplateTransferDragSourceListener
implements TransferDragSourceListener {
    private final TableViewer viewer;
    private PaletteState paletteState = null;
    private EditDomain editDomain;

    public EntityTemplateTransferDragSourceListener(TableViewer tableViewer, PaletteState paletteState) {
        this.viewer = tableViewer;
        this.paletteState = paletteState;
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection entry;
        if (this.viewer != null && (entry = (IStructuredSelection)this.viewer.getSelection()) != null && !entry.isEmpty()) {
            Set<String> modulesIds;
            Object selectedElement = entry.getFirstElement();
            NodeDefinitionPaletteEntry object = this.getNodeFromSelection(selectedElement);
            Object template = this.getTemplate(object, modulesIds = PaletteHelper.getModuleIdsContaining(selectedElement));
            if (template == null) {
                if (selectedElement instanceof ModulePaletteEntry) {
                    event.data = selectedElement;
                    TemplateTransfer.getInstance().setTemplate((Object)NullCreationFactory.getInstance());
                    event.image = ((ModulePaletteEntry)selectedElement).getIcon();
                } else {
                    event.doit = false;
                }
            } else {
                if (!this.paletteState.isEmptySearchFilter().booleanValue()) {
                    AnalyticsRecordsFactory.single((String)Events.ADD_MODULE_FROM_SEARCH_IN_PALETTE_FILTER, (String[])new String[]{"schema", object.getId()}).track();
                }
                TemplateTransfer.getInstance().setTemplate(template);
                event.image = object.getIcon();
            }
        }
        event.offsetX = 0;
        event.offsetY = 0;
    }

    private Object getTemplate(NodeDefinitionPaletteEntry object, Set<String> modulesIds) {
        if (object == null) {
            return null;
        }
        return PaletteHelper.createFactory(object.getNodeDefinition(), modulesIds);
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.doit) {
            TemplateTransfer.getInstance().setTemplate(null);
            if (this.editDomain != null) {
                this.editDomain.setActiveTool(this.editDomain.getDefaultTool());
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection entry;
        if (this.viewer != null && (entry = (IStructuredSelection)this.viewer.getSelection()) != null && !entry.isEmpty()) {
            Set<String> modulesIds;
            Object selectedElement = entry.getFirstElement();
            NodeDefinitionPaletteEntry object = this.getNodeFromSelection(selectedElement);
            Object template = this.getTemplate(object, modulesIds = PaletteHelper.getModuleIdsContaining(selectedElement));
            if (template != null) {
                event.data = template;
            } else if (selectedElement instanceof ModulePaletteEntry) {
                event.data = selectedElement;
            }
        }
    }

    private NodeDefinitionPaletteEntry getNodeFromSelection(Object entry) {
        NodeDefinitionPaletteEntry object = null;
        if (entry != null) {
            if (entry instanceof NodeDefinitionPaletteEntry) {
                object = (NodeDefinitionPaletteEntry)entry;
            } else if (entry instanceof SearchResult) {
                SearchResult searchResult = (SearchResult)entry;
                object = searchResult.getNode();
            }
        }
        return object;
    }

    public Transfer getTransfer() {
        return TemplateTransfer.getInstance();
    }

    public void setEditDomain(EditDomain editDomain) {
        this.editDomain = editDomain;
    }
}

