/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gef.requests.CreationFactory;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitor;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.Keyword;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.ui.palette.AddModuleCreationFactoryDecorator;
import org.mule.tooling.ui.palette.ContainerCreationFactory;
import org.mule.tooling.ui.palette.EndpointCreationFactory;
import org.mule.tooling.ui.palette.PatternCreationFactory;
import org.mule.tooling.ui.palette.SplitterCreationFactory;
import org.mule.tooling.ui.palette.core.SearchResult;
import org.mule.tooling.ui.palette.core.SimpleNodeDefinitionDecorator;
import org.mule.tooling.utils.ObjectHolder;

public enum PaletteHelper {
    INSTANCE;

    private static Set<String> definitionsToSkip;

    static {
        definitionsToSkip = new HashSet<String>();
    }

    public boolean skip(String id, String category) {
        return definitionsToSkip.contains(PaletteHelper.combine(id, category));
    }

    public void addDefinitionToSkip(String id, String category) {
        definitionsToSkip.add(PaletteHelper.combine(id, category));
    }

    private static String combine(String id, String category) {
        return id + ":" + category;
    }

    public boolean hasKeywords(List<Keyword> keywords, String filterString) {
        if (keywords != null) {
            for (Keyword keyword : keywords) {
                if (StringUtils.isEmpty((String)filterString) || filterString.contains(" ") || filterString.length() <= 1 || !keyword.getKeyword().startsWith(filterString.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public int getKeywordWeight(List<Keyword> keywords, String filterString) {
        if (keywords != null) {
            for (Keyword keyword : keywords) {
                if (StringUtils.isEmpty((String)filterString) || filterString.contains(" ") || filterString.length() <= 1 || !keyword.getKeyword().startsWith(filterString.toLowerCase())) continue;
                return keyword.getWeight();
            }
        }
        return 0;
    }

    public String getRuntimeVersion(IMuleProject muleProject) {
        return muleProject.getServerDefinition() == null ? null : muleProject.getServerDefinition().getVersionWithEESign();
    }

    public List<CategoryDefinition> getSortedCategoryDefinitions(Collection<String> categoryNames, IMuleModuleManager moduleManager) {
        ArrayList<CategoryDefinition> categoryDefinitions = new ArrayList<CategoryDefinition>();
        for (String categoryName : categoryNames) {
            Optional optionalCategory = moduleManager.getCategory(categoryName);
            if (!optionalCategory.isPresent()) continue;
            categoryDefinitions.add((CategoryDefinition)optionalCategory.get());
        }
        Collections.sort(categoryDefinitions);
        return categoryDefinitions;
    }

    public static Set<String> getModuleIdsContaining(Object entry) {
        NodeDefinition nodeDefinition;
        if (entry instanceof SearchResult) {
            return ((SearchResult)entry).getAvailableModules();
        }
        if (entry instanceof SimpleNodeDefinitionDecorator && (nodeDefinition = ((SimpleNodeDefinitionDecorator)entry).getNodeDefinition()) != null) {
            return Stream.of(nodeDefinition.getBundleSymbolicName()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static CreationFactory createEntry(NodeDefinition def) {
        return PaletteHelper.createFactory(def, Collections.emptySet());
    }

    public static CreationFactory createFactory(NodeDefinition def, final Set<String> modulesIds) {
        final ObjectHolder entry = new ObjectHolder();
        def.accept(new NodeDefinitionVisitor(){

            public void visitPatternDefinition(PatternDefinition patternDefinition) {
                entry.set((Object)new AddModuleCreationFactoryDecorator(new PatternCreationFactory(patternDefinition), modulesIds));
            }

            public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
                entry.set((Object)new AddModuleCreationFactoryDecorator(new EndpointCreationFactory(endpointDefinition), modulesIds));
            }

            public void visitContainerDefinition(ContainerDefinition containerDefinition) {
                entry.set((Object)new AddModuleCreationFactoryDecorator(new ContainerCreationFactory(containerDefinition), modulesIds));
            }

            public void visitSplitterDefinition(SplitterDefinition splitterDefinition) {
                entry.set((Object)new AddModuleCreationFactoryDecorator(new SplitterCreationFactory(splitterDefinition), modulesIds));
            }

            public void visitGlobalDefinition(GlobalDefinition globalDefinition) {
                this.logUnexpectedCall((NodeDefinition)globalDefinition);
            }

            public void visitNestedDefinition(NestedDefinition nestedDefinition) {
                this.logUnexpectedCall((NodeDefinition)nestedDefinition);
            }

            public void visitNestedContainerDefinition(NestedContainerDefinition nestedContainerDefinition) {
                this.logUnexpectedCall((NodeDefinition)nestedContainerDefinition);
            }

            public void visitRouteDefinition(RouteDefinition routeDefinition) {
                this.logUnexpectedCall((NodeDefinition)routeDefinition);
            }

            protected void logUnexpectedCall(NodeDefinition definition) {
                MuleCorePlugin.logError((String)("PaletteHelper called with unsupported class [" + String.valueOf(definition.getClass()) + "] Id:" + definition.getId()), (Throwable)new RuntimeException());
            }
        });
        return (CreationFactory)entry.get();
    }
}

