/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.core;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.ui.palette.PalettePlugin;
import org.mule.tooling.ui.palette.core.NodeDefinitionPaletteEntry;
import org.mule.tooling.ui.palette.core.PaletteMainEntry;

public class SearchResult {
    private static final String NOT_FOUND_MESSAGE = "The searched term could not be found in the project";
    private Set<String> availablesModules;
    public static final SearchResult EMPTY = new SearchResult(){

        @Override
        public Optional<Image> getDetailIcon() {
            return Optional.empty();
        }

        @Override
        public String getDetailText() {
            return SearchResult.NOT_FOUND_MESSAGE;
        }

        @Override
        public Image getMainIcon() {
            return PalettePlugin.getDefault().getAddModuleIcon();
        }

        @Override
        public String getMainText() {
            return "Search in Exchange...";
        }
    };
    private final PaletteMainEntry group;
    private final NodeDefinitionPaletteEntry node;
    private final String tooltip;
    private final boolean localResult;

    private SearchResult() {
        this(null, null, "", false, Collections.emptySet());
    }

    public SearchResult(PaletteMainEntry group, NodeDefinitionPaletteEntry node, String tooltip, boolean localResult, Set<String> availablesModules) {
        this.group = group;
        this.node = node;
        this.tooltip = tooltip;
        this.localResult = localResult;
        this.availablesModules = availablesModules;
    }

    public PaletteMainEntry getGroup() {
        return this.group;
    }

    public NodeDefinitionPaletteEntry getNode() {
        return this.node;
    }

    public boolean isEmptyResult() {
        return this.node == null;
    }

    public Image getMainIcon() {
        return this.group.getIcon();
    }

    public Optional<Image> getDetailIcon() {
        return Optional.ofNullable(this.node.getIcon());
    }

    public String getMainText() {
        return this.getGroup().getDisplayName();
    }

    public String getDetailText() {
        return this.getNode().getDisplayName();
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean isLocalResult() {
        return this.localResult;
    }

    public Set<String> getAvailableModules() {
        return this.availablesModules;
    }

    public void addAvailableModule(Set<String> moduleVersions) {
        this.availablesModules.addAll(moduleVersions);
    }
}

