/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette.core;

import java.util.function.Supplier;
import org.eclipse.swt.graphics.Image;

public class PaletteEntry {
    private final String id;
    private final String displayName;
    private final String tooltip;
    private final Supplier<Image> iconSupplier;
    private final boolean isDeprecated;
    private Image icon;

    public PaletteEntry(String id, String displayName, String tooltip, Supplier<Image> iconSupplier, boolean isDeprecated) {
        this.id = id;
        this.displayName = displayName;
        this.tooltip = tooltip;
        this.iconSupplier = iconSupplier;
        this.isDeprecated = isDeprecated;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Image getIcon() {
        if (this.icon == null) {
            this.icon = this.iconSupplier.get();
        }
        return this.icon;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String toString() {
        return "PaletteDragableEntry [id=" + this.id + ", displayName=" + this.displayName + ", tooltip=" + this.tooltip + ", isDeprecated=" + this.isDeprecated + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.isDeprecated ? 1231 : 1237);
        result = 31 * result + (this.tooltip == null ? 0 : this.tooltip.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaletteEntry other = (PaletteEntry)obj;
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.isDeprecated != other.isDeprecated) {
            return false;
        }
        return !(this.tooltip == null ? other.tooltip != null : !this.tooltip.equals(other.tooltip));
    }
}

