/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.images.StudioImages;
import org.mule.tooling.templatesrepo.views.TemplatesImages;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.LoggingStatus;
import org.osgi.framework.BundleContext;

public class PalettePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.mule.tooling.ui.palette";
    public static final String FAVORITES_ID = "org.mule.tooling.favorites";
    public static final String CORE_ID = "org.mule.tooling.core";
    public static final String LOCAL_MODULES_ID = "org.mule.tooling.local";
    private static final String PALETTE_BACKGROUND = "palette-background";
    private static final String PALETTE_DARK_BACKGROUND = "palette-dark-background";
    private static final String SEPARATOR = "separator";
    private static final String SEPARATOR_DARK = "separator-dark";
    private static final String GENERIC_MODULE = "generic-module";
    private static final String ADD_MODULE = "add-module";
    private static final String EXCHANGE = "exchange";
    private static PalettePlugin plugin;

    public static PalettePlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(CORE_ID, StudioImages.OBJ_MULE);
        reg.put(FAVORITES_ID, StudioImages.PALETTE_FAVORITES);
        reg.put(ADD_MODULE, StudioImages.PALETTE_ADD_MODULE);
        reg.put(GENERIC_MODULE, StudioImages.PALETTE_MODULE_GENERIC);
        reg.put(SEPARATOR, StudioImages.OBJ_SEPARATOR);
        reg.put(SEPARATOR_DARK, StudioImages.OBJ_SEPARATOR_DARK);
        reg.put(PALETTE_BACKGROUND, StudioImages.VIEWBG_PALETTE);
        reg.put(PALETTE_DARK_BACKGROUND, StudioImages.VIEWBG_PALETTE_DARK);
        reg.put(LOCAL_MODULES_ID, StudioImages.PALETTE_LOCAL_PALETTE);
        reg.put(EXCHANGE, TemplatesImages.TEMPLATES_IMAGE);
    }

    public Image getCoreModuleIcon() {
        return this.getImageRegistry().get(CORE_ID);
    }

    public Image getFavoritesIcon() {
        return this.getImageRegistry().get(FAVORITES_ID);
    }

    public Image getAddModuleIcon() {
        return this.getImageRegistry().get(ADD_MODULE);
    }

    public Image getGenericModuleIcon() {
        return this.getImageRegistry().get(GENERIC_MODULE);
    }

    public Image getSeparatorImage() {
        if (ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme) {
            return this.getImageRegistry().get(SEPARATOR_DARK);
        }
        return this.getImageRegistry().get(SEPARATOR);
    }

    public Image getPaletteBackground() {
        if (ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme) {
            return this.getImageRegistry().get(PALETTE_DARK_BACKGROUND);
        }
        return this.getImageRegistry().get(PALETTE_BACKGROUND);
    }

    public Image getPaletteLocalImage() {
        return this.getImageRegistry().get(LOCAL_MODULES_ID);
    }

    public Image getExchangeIcon() {
        return this.getImageRegistry().get(EXCHANGE);
    }

    public static void logError(String message, Throwable t) {
        PalettePlugin.getDefault().getLog().log(PalettePlugin.createLoggingStatus(4, message, t));
    }

    public static void logWarning(String message, Throwable t) {
        PalettePlugin.getDefault().getLog().log(PalettePlugin.createLoggingStatus(2, message, t));
    }

    public static void logWarning(String message) {
        PalettePlugin.getDefault().getLog().log(PalettePlugin.createLoggingStatus(2, message, null));
    }

    public static void logInfo(String message) {
        PalettePlugin.getDefault().getLog().log(PalettePlugin.createLoggingStatus(1, message, null));
    }

    private static IStatus createLoggingStatus(int type, String message, Throwable t) {
        return new LoggingStatus(type, PLUGIN_ID, message, t);
    }
}

