/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.ui.palette.utils.PaletteFavoritesChangedEvent;
import org.mule.tooling.utils.eventbus.IEvent;
import org.osgi.service.prefs.BackingStoreException;

public enum PaletteManager {
    INSTANCE;

    private static final String FAVORITES_PREFERENCE_ID = "favorites";
    public static final String DEPRECATED_SUFFIX = " (Deprecated)";
    private static final String SHOW_DEPRECATED_ELEMENTS = "showDeprecatedElements";
    private static final String DEFAULT_FAVORITES = "http://www.mulesoft.org/schema/mule/core/logger,http://www.mulesoft.org/schema/mule/http/listener,http://www.mulesoft.org/schema/mule/http/request,http://www.mulesoft.org/schema/mule/ee/core/transform,http://www.mulesoft.org/schema/mule/core/set-payload,http://www.mulesoft.org/schema/mule/core/flow-ref,http://www.mulesoft.org/schema/mule/core/variable-transformer,http://www.mulesoft.org/schema/mule/file/directory-listener,http://www.mulesoft.org/schema/mule/core/choice,http://www.mulesoft.org/schema/mule/json/object-to-json-transformer";

    private IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.palette");
    }

    private String getShowDeprecatedElementsKey(String version) {
        return SHOW_DEPRECATED_ELEMENTS + version;
    }

    public void saveShowDeprecatedElements(IServerDefinition serverDefinition, boolean showDeprecatedElements) {
        String versionWithEESign = serverDefinition.getVersion();
        try {
            IEclipsePreferences preferences = this.getPreferences();
            preferences.putBoolean(this.getShowDeprecatedElementsKey(versionWithEESign), showDeprecatedElements);
            preferences.flush();
        }
        catch (BackingStoreException e) {
            MuleCorePlugin.logError((String)("Failed to save the show deprecated preference for the " + versionWithEESign + " version "), (Throwable)e);
        }
    }

    public boolean showsDeprecatedComponents(IServerDefinition serverDefinition) {
        String showDeprecatedElementsKey = this.getShowDeprecatedElementsKey(serverDefinition.getVersion());
        return this.showDeprecatedComponents(showDeprecatedElementsKey);
    }

    public boolean showDeprecatedComponents(String version) {
        IEclipsePreferences preferences = this.getPreferences();
        return preferences.getBoolean(version, Boolean.FALSE.booleanValue());
    }

    public static void addToFavorites(String id) {
        List<String> userFavorites = Arrays.asList(InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.palette").get(FAVORITES_PREFERENCE_ID, DEFAULT_FAVORITES).split(","));
        if (!userFavorites.contains(id)) {
            String currentIds = InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.palette").get(FAVORITES_PREFERENCE_ID, DEFAULT_FAVORITES);
            InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.palette").put(FAVORITES_PREFERENCE_ID, currentIds + "," + id);
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new PaletteFavoritesChangedEvent());
        }
    }

    public static List<String> getFavorites() {
        ArrayList<String> favorites = new ArrayList<String>();
        List<String> userFavorites = Arrays.asList(InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.palette").get(FAVORITES_PREFERENCE_ID, DEFAULT_FAVORITES).split(","));
        favorites.addAll(userFavorites);
        return favorites;
    }

    public static void removeFromFavorites(String id) {
        List<String> userFavorites = Arrays.asList(InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.palette").get(FAVORITES_PREFERENCE_ID, DEFAULT_FAVORITES).split(","));
        ArrayList<String> newList = new ArrayList<String>();
        newList.addAll(userFavorites);
        newList.remove(id);
        InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.palette").put(FAVORITES_PREFERENCE_ID, newList.stream().collect(Collectors.joining(",")));
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new PaletteFavoritesChangedEvent());
    }

    public static void restoreDefaults() {
        InstanceScope.INSTANCE.getNode("org.mule.tooling.ui.palette").put(FAVORITES_PREFERENCE_ID, DEFAULT_FAVORITES);
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new PaletteFavoritesChangedEvent());
    }
}

