/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.ProjectModelState;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.core.module.runner.ExtensionsCallback;
import org.mule.tooling.core.utils.VersionComparator;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.utils.MavenCompilerConfigurer;

public class AddModulesHelper {
    private static final String JAVA_MODULE_GA = "org.mule.module:mule-java-module";
    private final IMuleProject muleProject;
    private final Supplier<List<ExternalContributionMuleModule>> modulesSupplier;

    private AddModulesHelper(IMuleProject muleProject, Supplier<List<ExternalContributionMuleModule>> modulesSupplier) {
        this.muleProject = muleProject;
        this.modulesSupplier = modulesSupplier;
    }

    public static AddModulesHelper create(IMuleProject muleProject, Supplier<List<ExternalContributionMuleModule>> modulesSupplier) {
        return new AddModulesHelper(muleProject, modulesSupplier);
    }

    public void addModules() {
        if (this.muleProject.getProjectModelState() == ProjectModelState.VALID) {
            ArrayList projectModules = new ArrayList(this.muleProject.getModuleManager(EditingScope.APP).getExternalModules());
            ArrayList<ExternalContributionMuleModule> allModules = new ArrayList<ExternalContributionMuleModule>(this.muleProject.getModuleManager(EditingScope.TEST).getExternalModules());
            ArrayList<ExternalContributionMuleModule> testExtensions = new ArrayList<ExternalContributionMuleModule>(allModules);
            testExtensions.removeAll(projectModules);
            List<ExternalContributionMuleModule> newModules = this.modulesSupplier.get();
            if (newModules != null && !newModules.isEmpty()) {
                List<ExternalContributionMuleModule> modulesToRemove = this.getModulesToRemove(allModules, newModules);
                modulesToRemove.forEach(this::safeRemoveExtension);
                List<ExternalContributionMuleModule> modulesToAdd = this.getModulesToAdd(allModules, newModules);
                this.addModulesToProject(modulesToAdd, testExtensions);
            }
        } else {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Search in Exchange...", (String)"The current project has an invalid pom.xml file. Please correct the issues before proceeding.");
        }
    }

    private List<ExternalContributionMuleModule> getModulesToAdd(List<ExternalContributionMuleModule> projectModules, List<ExternalContributionMuleModule> newModules) {
        ArrayList<ExternalContributionMuleModule> modulesToAdd = new ArrayList<ExternalContributionMuleModule>(newModules);
        modulesToAdd.removeAll(projectModules);
        return modulesToAdd;
    }

    private List<ExternalContributionMuleModule> getModulesToRemove(List<ExternalContributionMuleModule> projectModules, List<ExternalContributionMuleModule> newModules) {
        Map<String, String> dependenciesToAddGA = newModules.stream().map(MuleModule::getId).map(MavenUtils::getPluginDependency).collect(Collectors.toMap(MavenUtils::getGA, MavenCoordinates::getVersion));
        return projectModules.stream().filter(module -> {
            String eachGA = MavenUtils.getGA((MavenDependency)MavenUtils.getPluginDependency((String)module.getId()));
            if (dependenciesToAddGA.containsKey(eachGA)) {
                String versionToAdd = (String)dependenciesToAddGA.get(eachGA);
                VersionComparator muleVersionComparator = VersionComparator.forVersion((String)versionToAdd);
                return muleVersionComparator.compareVersionTo(module.getVersion()) > 0;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private void safeRemoveExtension(ExternalContributionMuleModule x) {
        try {
            this.muleProject.removeMuleExtension(x);
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Unexpected error while removing extension", (Throwable)e);
        }
    }

    private void addModulesToProject(List<ExternalContributionMuleModule> muleModules, List<ExternalContributionMuleModule> testExtensions) {
        List dependencies = muleModules.stream().map(externalModule -> MavenUtils.getPluginDependency((String)externalModule.getId())).collect(Collectors.toList());
        Set testExtensionsGA = testExtensions.stream().map(MuleModule::getId).map(MavenUtils::getPluginDependency).map(MavenUtils::getGA).collect(Collectors.toSet());
        ArtifactResolvingRunnerFactory.syncInstance().runResolvingExtensions(this.muleProject, dependencies, ExtensionsCallback.builder().onSuccess(modules -> modules.forEach(module -> {
            try {
                String moduleIdGA = MavenUtils.getGA((MavenDependency)MavenUtils.getPluginDependency((String)module.getId()));
                if (testExtensionsGA.contains(moduleIdGA)) {
                    this.muleProject.addMuleTestExtension(module);
                } else {
                    this.muleProject.addMuleExtension(module);
                }
                this.addRequiredLibraries((ExternalContributionMuleModule)module, (IProgressMonitor)new NullProgressMonitor());
                this.updatePomIfRequired((ExternalContributionMuleModule)module);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)"Unexpected error adding required libraries", (Throwable)e);
            }
        })).onErrorLog().build(), (IProgressMonitor)new NullProgressMonitor());
    }

    private void updatePomIfRequired(ExternalContributionMuleModule module) {
        if (this.isJavaModule(module.getId())) {
            new MavenCompilerConfigurer(this.muleProject).configureMavenCompilerIfAbsent();
        }
    }

    private boolean isJavaModule(String moduleId) {
        return moduleId.startsWith("org.mule.module:mule-java-module:");
    }

    private void addRequiredLibraries(ExternalContributionMuleModule ext, IProgressMonitor monitor) {
        Set requiredLibraries = ext.getRequiredLibraries();
        if (!requiredLibraries.isEmpty()) {
            MavenMuleProjectDecorator decorated = MavenMuleProjectDecorator.decorate((IMuleProject)this.muleProject);
            ArtifactResolvingRunnerFactory.asyncInstance().runResolvingDependencies(this.muleProject, new ArrayList(requiredLibraries), DependenciesCallback.builder().onSuccess(sharedLibs -> {
                List resolvedDependencies = requiredLibraries.stream().filter(requirement -> sharedLibs.get(requirement) != null).collect(Collectors.toList());
                decorated.addDependencies(resolvedDependencies);
            }).onErrorLog().build(), monitor);
        }
    }
}

