/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.messageflow.editor.Interruptible;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.palette.AddModulesHelper;
import org.mule.tooling.ui.palette.CreationFactoryDecorator;
import org.mule.tooling.ui.palette.view.SelectModuleVersionDialog;
import org.mule.tooling.utils.ObjectHolder;

public class AddModuleCreationFactoryDecorator
extends CreationFactoryDecorator
implements Interruptible {
    private Set<String> modulesIdSet;

    public AddModuleCreationFactoryDecorator(CreationFactory decorated, Set<String> modulesIds) {
        super(decorated);
        this.modulesIdSet = modulesIds;
    }

    public boolean proceed() {
        ObjectHolder shouldContinue = new ObjectHolder();
        shouldContinue.set((Object)true);
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        AddModulesHelper.create(muleProject, () -> {
            if (!this.modulesIdSet.isEmpty()) {
                ArrayList<ExternalContributionMuleModule> externalModuleList = new ArrayList<ExternalContributionMuleModule>();
                for (String module : this.modulesIdSet) {
                    Optional externalModule = MuleCorePlugin.getModuleContributionManager().getExternalModule(muleProject.getServerDefinition(), module);
                    if (!externalModule.isPresent()) continue;
                    externalModuleList.add((ExternalContributionMuleModule)externalModule.get());
                }
                if (!externalModuleList.isEmpty()) {
                    String module;
                    module = (ExternalContributionMuleModule)externalModuleList.get(0);
                    Optional<ExternalContributionMuleModule> declaredModuleWithSameGA = this.getDeclaredModuleWithSameGA(muleProject, (ExternalContributionMuleModule)module);
                    if (declaredModuleWithSameGA.isPresent()) {
                        Optional<ExternalContributionMuleModule> declaredModuleWithSameGAAndVersion = this.getDeclaredModuleWithSameGAAndVersion(declaredModuleWithSameGA.get(), externalModuleList);
                        if (!declaredModuleWithSameGAAndVersion.isPresent()) {
                            MessageDialog dialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Operation not available", null, String.format("The %s operation is available in version %s, but your project currently has version %s.\n\nDo you want to modify the module version to use this operation?", this.getOperationName((NodeDefinition)this.getNewObject()), module.getVersion(), declaredModuleWithSameGA.get().getVersion()), 4, new String[]{"Confirm", "Cancel"}, 0);
                            if (dialog.open() == 0) {
                                return Arrays.asList(module);
                            }
                            shouldContinue.set((Object)false);
                        }
                    } else {
                        if (externalModuleList.size() > 1) {
                            SelectModuleVersionDialog dialog = new SelectModuleVersionDialog(Display.getCurrent().getActiveShell(), muleProject, externalModuleList);
                            int open = dialog.open();
                            if (open == 0) {
                                ExternalContributionMuleModule muleModule = dialog.getSelectedModule();
                                return Arrays.asList(muleModule);
                            }
                            shouldContinue.set((Object)false);
                            return Collections.emptyList();
                        }
                        return Arrays.asList(module);
                    }
                }
            }
            return Collections.emptyList();
        }).addModules();
        return (Boolean)shouldContinue.get();
    }

    private Optional<ExternalContributionMuleModule> getDeclaredModuleWithSameGAAndVersion(ExternalContributionMuleModule moduleInProject, List<ExternalContributionMuleModule> externalModuleList) {
        if (externalModuleList.contains(moduleInProject)) {
            return Optional.of(moduleInProject);
        }
        return Optional.empty();
    }

    private Optional<ExternalContributionMuleModule> getDeclaredModuleWithSameGA(IMuleProject muleProject, ExternalContributionMuleModule module) {
        String moduleGA = MavenUtils.getGA((MavenDependency)MavenUtils.getPluginDependency((String)module.getId()));
        List externalModules = muleProject.getModuleManager().getExternalModules();
        return externalModules.stream().filter(x -> MavenUtils.getGA((MavenDependency)MavenUtils.getPluginDependency((String)x.getId())).equals(moduleGA)).findFirst();
    }

    private String getOperationName(NodeDefinition nodeDefinition) {
        return nodeDefinition.getName();
    }
}

