/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.internal.palette.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;
import org.mule.runtime.api.util.Pair;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.DefaultExtensionDependenciesProvider;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.FeaturedModulesTracker;
import org.mule.tooling.core.module.IModuleContributionManager;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.VersionComparator;
import org.mule.tooling.messageflow.editor.VirtualMuleProject;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.ui.palette.PaletteManager;
import org.mule.tooling.ui.palette.PalettePlugin;
import org.mule.tooling.ui.palette.core.ModulePaletteEntry;
import org.mule.tooling.ui.palette.core.NodeDefinitionPaletteEntry;
import org.mule.tooling.ui.palette.core.PaletteCategory;
import org.mule.tooling.ui.palette.core.PaletteEntry;
import org.mule.tooling.ui.palette.core.PaletteMainEntry;
import org.mule.tooling.ui.palette.core.SearchResult;
import org.mule.tooling.ui.palette.core.SimpleNodeDefinition;
import org.mule.tooling.ui.palette.core.SimpleNodeDefinitionDecorator;
import org.mule.tooling.ui.palette.view.PaletteFilter;
import org.mule.tooling.utils.collection.ListView;

public class PaletteContentFactory {
    private static final String MUNIT_MODULE_PREFIX = "MUnit";
    private static final String COMPONENTS_ID = "org.mule.tooling.components";
    private static final String COMPONENTS_DISPLAY_NAME = "Operations";
    private static final String SCOPE_AND_ROUTERS_ID = "org.mule.tooling.scope";
    private static final String SCOPE_AND_ROUTERS_DISPLAY_NAME = "Scopes And Routers";
    private static final String FAVORITES_DISPLAY_NAME = "Favorites";
    private static final String CORE_DISPLAY_NAME = "Core";
    public static final String LOCAL_MODULES_DISPLAY_NAME = "Add Modules";
    public static final String DEFAULT_MODULES_CATEGORY_ID = "default";
    public static final String WORKSPACE_MODULES_CATEGORY_ID = "workspace";
    public static final String DEFAULT_MODULES_CATEGORY_DISPLAY_NAME = "Featured";
    public static final String WORKSPACE_MODULES_CATEGORY_DISPLAY_NAME = "Workspace";
    private static final String LOCAL_MODULES_TOOLTIP = "Drag and drop directly in the palette to install these modules in your project";
    private static final String DEFAULT_TOOLTIP = "Bundled in Studio";
    private static final String WORKSPACE_TOOLTIP = "Available in open projects";
    private static final PaletteEntry NO_ELEMENTS_AVAILABLE = new PaletteEntry("noElements", "No operations available", "No operation where provided for this connector", () -> null, false);
    private static final PaletteCategory EMPTY_CATEGORY = new PaletteCategory("INTERNAL_EMPTY_CATEGORY", "No elements available", Collections.singletonList(NO_ELEMENTS_AVAILABLE), "");
    private static Map<String, PaletteMainEntry> coreDefinitionGroups = new HashMap<String, PaletteMainEntry>();

    private PaletteContentFactory() {
    }

    public static List<PaletteMainEntry> createFrom(IMuleProject project, boolean isTestFolder) {
        if (project instanceof VirtualMuleProject) {
            return Collections.emptyList();
        }
        IModuleContributionManager moduleContributionManager = MuleCorePlugin.getModuleContributionManager();
        ArrayList<PaletteMainEntry> definitionGroups = new ArrayList<PaletteMainEntry>();
        PaletteMainEntry localGroup = PaletteContentFactory.createLocalGroup(project, moduleContributionManager, isTestFolder);
        definitionGroups.add(localGroup);
        PaletteMainEntry favoritesInstance = PaletteContentFactory.createFavoritesGroup(project);
        definitionGroups.add(favoritesInstance);
        PaletteMainEntry coreDefinitionGroup = PaletteContentFactory.getOrCreateCoreDefinitionGroup(project);
        definitionGroups.add(coreDefinitionGroup);
        project.getModuleManager().getExternalModules().stream().sorted((p1, p2) -> p1.getName().toLowerCase().compareTo(p2.getName().toLowerCase())).filter(externalContributionMuleModule -> isTestFolder || !externalContributionMuleModule.getName().startsWith(MUNIT_MODULE_PREFIX)).distinct().forEach(externalContributionMuleModule -> {
            if (MuleProjectKind.APPLICATION.classifies(project) && !((IMuleApplicationProject)project).hasDefaultDomain() && ((IMuleApplicationProject)project).getDomain() != null) {
                boolean isDefinedInDomain = CoreUtils.isExternalContributionDefinedInProjectModel((ExternalContributionMuleModule)externalContributionMuleModule, (IMuleProjectModel)((IMuleApplicationProject)project).getDomain().getMuleProjectModel());
                definitionGroups.add(PaletteContentFactory.createExternalContributionGroup(externalContributionMuleModule, isDefinedInDomain));
            } else {
                definitionGroups.add(PaletteContentFactory.createExternalContributionGroup(externalContributionMuleModule, false));
            }
        });
        return definitionGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PaletteMainEntry getOrCreateCoreDefinitionGroup(IMuleProject project) {
        Map<String, PaletteMainEntry> map = coreDefinitionGroups;
        synchronized (map) {
            return coreDefinitionGroups.computeIfAbsent(project.getServerDefinition().getVersionWithSuffix(), x -> PaletteContentFactory.createCoreGroup(project));
        }
    }

    public static void cleanCoreDefinitionGroups() {
        coreDefinitionGroups.clear();
    }

    private static PaletteMainEntry createCoreGroup(IMuleProject project) {
        IMuleModuleManager moduleManager = project.getModuleManager();
        Set<String> categoryIds = PaletteContentFactory.getAllCategoriesFromModuleManager(moduleManager);
        List<PaletteCategory> categories = PaletteContentFactory.createCategories(project, moduleManager, categoryIds);
        categories.sort((c1, c2) -> c1.getDisplayName().compareTo(c2.getDisplayName()));
        boolean deprecated = false;
        return new PaletteMainEntry("org.mule.tooling.core", CORE_DISPLAY_NAME, () -> PalettePlugin.getDefault().getCoreModuleIcon(), categories, "Runtime " + project.getServerDefinition().getVersionWithSuffix() + " elements", deprecated);
    }

    private static PaletteMainEntry createLocalGroup(IMuleProject project, IModuleContributionManager manager, boolean isTestFolder) {
        IMuleModuleManager moduleManager = project.getModuleManager();
        IServerDefinition serverDefinition = project.getServerDefinition();
        List<PaletteCategory> categories = FeaturedModulesTracker.instance().isLoaded(serverDefinition.getId()) ? PaletteContentFactory.createLocalCategories(serverDefinition, moduleManager, manager, isTestFolder) : Arrays.asList(new PaletteCategory("loading", "Loading...", Collections.emptyList(), ""));
        boolean deprecated = false;
        return new PaletteMainEntry("org.mule.tooling.local", LOCAL_MODULES_DISPLAY_NAME, () -> PalettePlugin.getDefault().getAddModuleIcon(), categories, LOCAL_MODULES_TOOLTIP, deprecated);
    }

    private static List<PaletteCategory> createLocalCategories(IServerDefinition server, IMuleModuleManager moduleManager, IModuleContributionManager manager, boolean isTestFolder) {
        ArrayList<PaletteEntry> defaultModules = new ArrayList<PaletteEntry>();
        ArrayList<PaletteEntry> workspaceModules = new ArrayList<PaletteEntry>();
        PaletteContentFactory.populateDefaultAndWorkspaceModules(server, moduleManager, manager, defaultModules, workspaceModules, isTestFolder);
        PaletteContentFactory.sortEntries(defaultModules);
        PaletteCategory defaultCategory = new PaletteCategory(DEFAULT_MODULES_CATEGORY_ID, DEFAULT_MODULES_CATEGORY_DISPLAY_NAME, defaultModules, DEFAULT_TOOLTIP);
        PaletteContentFactory.sortEntries(workspaceModules);
        PaletteCategory workspaceCategory = new PaletteCategory(WORKSPACE_MODULES_CATEGORY_ID, WORKSPACE_MODULES_CATEGORY_DISPLAY_NAME, workspaceModules, WORKSPACE_TOOLTIP);
        return Arrays.asList(defaultCategory, workspaceCategory);
    }

    private static void populateDefaultAndWorkspaceModules(IServerDefinition server, IMuleModuleManager moduleManager, IModuleContributionManager manager, List<PaletteEntry> defaultModules, List<PaletteEntry> workspaceModules, boolean isTestFolder) {
        List modulesForServer = manager.getModulesFrom(server);
        Map<String, List<ExternalContributionMuleModule>> modulesByGroupAndArtifact = PaletteContentFactory.getModulesGroupedByGroupAndArtifact(server.getVersion(), modulesForServer, isTestFolder);
        DefaultExtensionDependenciesProvider defaultsProvider = MavenCore.getPomDefaultsHandlerManager().findProviderFor(server);
        List defaultExtensions = defaultsProvider.getDefaultExtensions().stream().map(MavenUtils::getGA).collect(Collectors.toList());
        for (List<ExternalContributionMuleModule> externalModules : modulesByGroupAndArtifact.values()) {
            ExternalContributionMuleModule moduleWithHighestVersion = (ExternalContributionMuleModule)externalModules.stream().max((x, y) -> x.getVersion().compareTo(y.getVersion())).get();
            ArrayList<ExternalContributionMuleModule> otherModules = new ArrayList<ExternalContributionMuleModule>(externalModules.size());
            otherModules.addAll(externalModules);
            otherModules.remove(moduleWithHighestVersion);
            MuleExtension extension = new MuleExtension(moduleWithHighestVersion.getId(), moduleWithHighestVersion.getId());
            if (moduleManager.containsExtension(extension)) continue;
            ModulePaletteEntry item = new ModulePaletteEntry(moduleWithHighestVersion, otherModules, () -> PaletteContentFactory.getIcon(moduleWithHighestVersion), false);
            if (defaultExtensions.contains(MavenUtils.getGA((MavenDependency)MavenUtils.getDependency((MuleExtension)extension)))) {
                defaultModules.add(item);
                continue;
            }
            workspaceModules.add(item);
        }
    }

    private static Image getIcon(ExternalContributionMuleModule module) {
        return module.getIconImage();
    }

    private static Map<String, List<ExternalContributionMuleModule>> getModulesGroupedByGroupAndArtifact(String serverVersion, List<ExternalContributionMuleModule> modulesForServer, boolean isTestFolder) {
        VersionComparator serverVersionComparator = VersionComparator.forVersion((String)serverVersion);
        Map<String, List<ExternalContributionMuleModule>> modulesByGroupAndArtifact = modulesForServer.stream().filter(externalContributionMuleModule -> isTestFolder || !externalContributionMuleModule.getName().startsWith(MUNIT_MODULE_PREFIX)).filter(x -> PaletteContentFactory.shouldInclude(serverVersionComparator, x)).collect(Collectors.groupingBy(x -> MavenUtils.getGA((MavenDependency)MavenUtils.getPluginDependency((String)x.getId()))));
        return modulesByGroupAndArtifact;
    }

    private static boolean shouldInclude(VersionComparator serverVersionComparator, ExternalContributionMuleModule module) {
        return module.getMinimumVersion() == null || serverVersionComparator.compareVersionTo(module.getMinimumVersion()) >= 0;
    }

    private static Set<String> getAllCategoriesFromModuleManager(IMuleModuleManager moduleManager) {
        HashSet<String> categoryIds = new HashSet<String>();
        for (CategoryDefinition category : moduleManager.getCategories()) {
            categoryIds.add(category.getId());
        }
        return categoryIds;
    }

    private static List<PaletteCategory> createCategories(IMuleProject project, IMuleModuleManager moduleManager, Set<String> categoryIds) {
        ArrayList<PaletteCategory> categories = new ArrayList<PaletteCategory>();
        for (String categoryId : categoryIds) {
            if (Category.CLOUD_CONNECTORS.getCategoryString().equals(categoryId)) continue;
            ArrayList nodes = new ArrayList();
            moduleManager.getCategory(categoryId).ifPresent(category -> {
                List definitionsForCategory = moduleManager.getDefinitionsForCategory(category.getId(), project.getServerDefinition().getVersionWithEESign());
                for (NodeDefinition definition : definitionsForCategory) {
                    if (!PaletteContentFactory.shouldIncludeDefinition(definition)) continue;
                    PaletteContentFactory.addToList(nodes, definition);
                }
                PaletteContentFactory.sortEntries(nodes);
                if (!nodes.isEmpty()) {
                    PaletteCategory categoryItem = new PaletteCategory(category.getId(), category.getName(), nodes);
                    categories.add(categoryItem);
                }
            });
        }
        return categories;
    }

    private static boolean shouldIncludeDefinition(NodeDefinition definition) {
        return definition.isVisibleInPalette() && !definition.isAbstract() && StringUtils.isNotBlank((String)definition.getName());
    }

    protected static void sortEntries(List<PaletteEntry> entries) {
        Collections.sort(entries, (x, y) -> x.getDisplayName().compareTo(y.getDisplayName()));
    }

    private static PaletteMainEntry createFavoritesGroup(IMuleProject project) {
        ArrayList<PaletteCategory> categories = new ArrayList<PaletteCategory>();
        ArrayList<PaletteEntry> nodes = new ArrayList<PaletteEntry>();
        IMuleModuleManager moduleManager = project.getModuleManager();
        IModuleContributionManager moduleContributionManager = MuleCorePlugin.getModuleContributionManager();
        List externalModulesForServer = moduleContributionManager.getExternalModules(project.getServerDefinition());
        List<String> ids = PaletteManager.getFavorites();
        for (String id : ids) {
            NodeDefinition definition = moduleManager.hasDefinition(id) ? moduleManager.getDefinition(id) : PaletteContentFactory.getNodeDefinition(id, project);
            if (definition == null) continue;
            List externalContributionsFrom = CoreUtils.getModulesContainingType((String)id, (List)externalModulesForServer);
            if (externalContributionsFrom.isEmpty()) {
                PaletteContentFactory.addToList(nodes, definition, CORE_DISPLAY_NAME);
                continue;
            }
            PaletteContentFactory.addToList(nodes, definition, ((ExternalContributionMuleModule)externalContributionsFrom.get(0)).getName());
        }
        PaletteCategory defaultCategory = new PaletteCategory(COMPONENTS_ID, COMPONENTS_DISPLAY_NAME, nodes);
        categories.add(defaultCategory);
        return new PaletteMainEntry("org.mule.tooling.favorites", FAVORITES_DISPLAY_NAME, () -> PalettePlugin.getDefault().getFavoritesIcon(), categories);
    }

    private static NodeDefinition getNodeDefinition(String id, IMuleProject project) {
        IModuleContributionManager externalModule = MuleCorePlugin.getModuleContributionManager();
        Iterator it = externalModule.getExternalContributionsMappedById(project.getServerDefinition()).entrySet().iterator();
        while (it.hasNext()) {
            for (NodeDefinition element : ((ExternalContributionMuleModule)it.next().getValue()).getDefinitions()) {
                if (!element.getId().equals(id)) continue;
                return element;
            }
        }
        return null;
    }

    private static PaletteMainEntry createExternalContributionGroup(ExternalContributionMuleModule externalContributionMuleModule, boolean isDefinedInDomain) {
        ArrayList<PaletteCategory> categories = new ArrayList<PaletteCategory>();
        ArrayList<PaletteEntry> operationsNodes = new ArrayList<PaletteEntry>();
        ArrayList<PaletteEntry> scopeAndRoutes = new ArrayList<PaletteEntry>();
        Collection definitions = externalContributionMuleModule.getDefinitions();
        for (NodeDefinition definition : definitions) {
            if (!definition.isVisibleInPalette() || definition.isAbstract()) continue;
            ArrayList<PaletteEntry> targetList = definition instanceof SplitterDefinition ? scopeAndRoutes : (definition instanceof ContainerDefinition ? scopeAndRoutes : operationsNodes);
            PaletteContentFactory.addToList(targetList, definition);
        }
        PaletteContentFactory.sortEntries(operationsNodes);
        PaletteContentFactory.sortEntries(scopeAndRoutes);
        if (!operationsNodes.isEmpty()) {
            PaletteCategory defaultCategory = new PaletteCategory(COMPONENTS_ID, COMPONENTS_DISPLAY_NAME, operationsNodes);
            categories.add(defaultCategory);
        }
        if (!scopeAndRoutes.isEmpty()) {
            PaletteCategory scopesAndRoutesCategory = new PaletteCategory(SCOPE_AND_ROUTERS_ID, SCOPE_AND_ROUTERS_DISPLAY_NAME, scopeAndRoutes);
            categories.add(scopesAndRoutesCategory);
        }
        if (categories.isEmpty()) {
            categories.add(EMPTY_CATEGORY);
        }
        boolean deprecated = false;
        return new PaletteMainEntry(externalContributionMuleModule.getId(), externalContributionMuleModule.getName() + (isDefinedInDomain ? " (domain)" : ""), () -> PaletteContentFactory.getIcon(externalContributionMuleModule), categories, externalContributionMuleModule.getVersion() + (isDefinedInDomain ? " (defined in domain)" : ""), deprecated);
    }

    protected static void addToList(List<PaletteEntry> nodes, NodeDefinition nodeDefinition) {
        PaletteContentFactory.addToList(nodes, nodeDefinition, null);
    }

    protected static void addToList(List<PaletteEntry> nodes, NodeDefinition nodeDefinition, String suffix) {
        NodeDefinitionPaletteEntry item = new SimpleNodeDefinition(nodeDefinition, () -> ((NodeDefinition)nodeDefinition).getIconImage());
        if (StringUtils.isNotBlank((String)suffix)) {
            item = new SimpleNodeDefinitionDecorator(item, suffix);
        }
        if (!nodes.contains(item)) {
            nodes.add(item);
        }
    }

    public static List<SearchResult> getSearchResults(List<PaletteMainEntry> paletteEntriesInProject, IMuleProject project, boolean isTestFolder, PaletteFilter filter) {
        List<PaletteMainEntry> paletteEntriesNotInProject = PaletteContentFactory.getAllPaletteEntriesNotInProject(project, isTestFolder);
        List allEntries = ListView.of(paletteEntriesInProject, paletteEntriesNotInProject);
        List<SearchResult> searchResults = allEntries.stream().map(PaletteContentFactory::getNodesFromPaletteEntry).flatMap(ls -> ls.stream()).filter(result -> filter.shouldShowResult((SearchResult)result)).collect(Collectors.toList());
        return PaletteContentFactory.mergeRepeatedItems(searchResults, project);
    }

    private static List<PaletteMainEntry> getAllPaletteEntriesNotInProject(IMuleProject project, boolean isTestFolder) {
        if (project instanceof VirtualMuleProject) {
            return Collections.emptyList();
        }
        IModuleContributionManager moduleContributionManager = MuleCorePlugin.getModuleContributionManager();
        List projectExternalModules = project.getModuleManager().getExternalModules();
        List externalModules = moduleContributionManager.getExternalModules(project.getServerDefinition());
        return externalModules.stream().sorted((p1, p2) -> p1.getName().toLowerCase().compareTo(p2.getName().toLowerCase())).filter(x -> !projectExternalModules.contains(x)).filter(module -> isTestFolder || !module.getName().startsWith(MUNIT_MODULE_PREFIX)).map(module -> PaletteContentFactory.createExternalContributionGroup(module, false)).collect(Collectors.toList());
    }

    private static List<SearchResult> getNodesFromPaletteEntry(PaletteMainEntry entry) {
        return entry.getCategories().stream().flatMap(category -> category.getEntries().stream()).filter(NodeDefinitionPaletteEntry.class::isInstance).map(NodeDefinitionPaletteEntry.class::cast).map(node -> new SearchResult(entry, (NodeDefinitionPaletteEntry)node, node.getTooltip(), true, (Set<String>)new HashSet<String>(Arrays.asList(node.getConnectorId())))).collect(Collectors.toList());
    }

    private static List<SearchResult> mergeRepeatedItems(List<SearchResult> results, IMuleProject project) {
        List externalModulesInProject = project.getModuleManager().getExternalModules();
        List externalModulesInProjectPair = externalModulesInProject.stream().map(x -> new Pair((Object)x.getName(), (Object)x.getVersion())).collect(Collectors.toList());
        ArrayList<SearchResult> resultsSet = new ArrayList<SearchResult>();
        for (SearchResult newResult : results) {
            Optional<SearchResult> existingModule = resultsSet.stream().filter(x -> PaletteContentFactory.haveSameNodeId(x, newResult)).findFirst();
            if (existingModule.isPresent()) {
                if (externalModulesInProjectPair.contains(new Pair((Object)newResult.getGroup().getDisplayName(), (Object)newResult.getGroup().getTooltip()))) {
                    newResult.addAvailableModule(existingModule.get().getAvailableModules());
                    resultsSet.removeIf(x -> x.getNode().getId().equals(newResult.getNode().getId()));
                    resultsSet.add(newResult);
                    continue;
                }
                existingModule.get().addAvailableModule(newResult.getAvailableModules());
                continue;
            }
            resultsSet.add(newResult);
        }
        return resultsSet;
    }

    private static boolean haveSameNodeId(SearchResult searchResult, SearchResult resultAccum) {
        return resultAccum.getNode().getId().equals(searchResult.getNode().getId());
    }

    public static boolean isDummyEntry(Object entry) {
        return entry instanceof PaletteEntry && NO_ELEMENTS_AVAILABLE.equals((PaletteEntry)entry);
    }
}

