/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.refactor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.mule.tooling.core.MuleCorePlugin;

public class UpdateRunConfigurationReferencesChange
extends Change {
    private String newName;
    private String oldName;

    public UpdateRunConfigurationReferencesChange(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    public String getName() {
        return MessageFormat.format("Rename references to {0} in run configurations", this.oldName);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ILaunchConfiguration[] launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        try {
            pm.beginTask("Updating references in run configurations", launchConfigurations.length);
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n = launchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                if (configuration.hasAttribute("mule-project-names")) {
                    this.checkAndUpdate(configuration, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    pm.worked(1);
                }
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        return new UpdateRunConfigurationReferencesChange(this.newName, this.oldName);
    }

    private void checkAndUpdate(ILaunchConfiguration configuration, IProgressMonitor progressMonitor) {
        block5: {
            try {
                List projectNames = configuration.getAttribute("mule-project-names", Collections.emptyList());
                if (!projectNames.contains(this.oldName)) break block5;
                try {
                    progressMonitor.beginTask("Updating run configuration " + configuration.getName(), 2);
                    this.update(configuration, projectNames, progressMonitor);
                }
                finally {
                    progressMonitor.done();
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)MessageFormat.format("There was a problem renaming references to {0} in run configurations", this.oldName), (Throwable)e);
            }
        }
    }

    private void update(ILaunchConfiguration configuration, List<String> projectNames, IProgressMonitor progressMonitor) throws CoreException {
        ArrayList<String> newProjectNames = new ArrayList<String>(projectNames);
        newProjectNames.remove(this.oldName);
        newProjectNames.add(this.newName);
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        workingCopy.setAttribute("mule-project-names", newProjectNames);
        progressMonitor.worked(1);
        if (workingCopy.getName().equals(this.oldName)) {
            workingCopy.rename(this.newName);
        }
        workingCopy.doSave();
        progressMonitor.worked(1);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public Object getModifiedElement() {
        return null;
    }
}

