/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.refactor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.runtime.ui.refactor.UpdateRunConfigurationReferencesChange;

public class RunConfigurationProjectRenameParticipant
extends RenameParticipant {
    private String originalName;

    protected boolean initialize(Object element) {
        if (element instanceof IProject) {
            return this.doInitialize((IProject)element);
        }
        return false;
    }

    private boolean doInitialize(IProject project) {
        try {
            if (CoreUtils.hasMuleNature((IProject)project)) {
                this.originalName = MuleRuntime.create((IProject)project).getName();
                return true;
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)("There was a problem initializing the rename participant to rename the project " + project.getName() + " in run configurations"), (Throwable)e);
        }
        return false;
    }

    public String getName() {
        return "Rename " + this.originalName + " in run configurations";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new UpdateRunConfigurationReferencesChange(this.originalName, this.getArguments().getNewName());
    }
}

