/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.launchconfig;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.MuleServerManager;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.common.ServerChooserComponent;
import org.mule.tooling.ui.launchConfiguration.extensible.LaunchConfigPartExtension;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandlerAdapter;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class ServerInLaunchComponent
implements LaunchConfigPartExtension {
    private static final String GROUP_TITLE = "Target Server Runtime";
    private String defaultServerId = CoreUtils.getDefaultServerRuntimeId();
    private ServerChooserComponent serverChooserComponent;
    private IPropertyChangeListener propertyChangeListener;
    private String selectedId;

    public Control createControl(Composite parent) {
        this.serverChooserComponent = new ServerChooserComponent(GROUP_TITLE);
        this.serverChooserComponent.createControl(parent);
        this.serverChooserComponent.setStatusHandler((PartStatusHandler)new PartStatusHandlerAdapter(){

            public void notifyUpdate(WizardPagePartExtension part, String key, Object value) {
                if ("serverDefinition".equals(key) && value != null) {
                    ServerInLaunchComponent.this.onSelectedServerChanged(value);
                }
            }
        });
        return parent;
    }

    private void onSelectedServerChanged(Object value) {
        String previousId = this.selectedId;
        this.selectedId = ((IServerDefinition)value).getId();
        if (this.propertyChangeListener != null) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "launch_mule_server_version", (Object)previousId, (Object)this.selectedId);
            this.propertyChangeListener.propertyChange(event);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String savedServerId;
        try {
            savedServerId = configuration.getAttribute("launch_mule_server_version", this.defaultServerId);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem retrieving the server configured for the run configuration", (Throwable)e);
            savedServerId = this.defaultServerId;
        }
        MuleServerManager serverManager = MuleCorePlugin.getServerManager();
        IServerDefinition serverDefinition = serverManager.containsServerDefinition(savedServerId) ? serverManager.getServerDefinition(savedServerId) : CoreUtils.getDefaultServer();
        this.serverChooserComponent.setServerDefinition(serverDefinition);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("launch_mule_server_version", this.selectedId);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("launch_mule_server_version", this.defaultServerId);
    }

    public void setPropertyChangeListener(IPropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    public void runPreLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    public void runPostLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    public void dispose() {
    }
}

