/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.launchconfig;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.common.MuleProjectChooserComponent;
import org.mule.tooling.ui.launchConfiguration.extensible.LaunchConfigPartExtension;

public class ProjectsInLaunchComponent
implements LaunchConfigPartExtension,
ICheckStateListener {
    private MuleProjectChooserComponent projectChooser;
    private IMuleProject[] muleProjects;
    private IPropertyChangeListener propertyChangeListener;

    public Control createControl(Composite parent) {
        this.muleProjects = this.getMuleProjects();
        this.projectChooser = new MuleProjectChooserComponent("Mule projects to launch", this.muleProjects);
        this.projectChooser.createControl(parent);
        this.projectChooser.addCheckStateListener((ICheckStateListener)this);
        return parent;
    }

    private IMuleProject[] getMuleProjects() {
        return MuleRuntime.getMuleProjects();
    }

    public void runPreLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    public void runPostLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        List<String> projectNamesList;
        try {
            projectNamesList = configuration.getAttribute("mule-project-names", Collections.emptyList());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem loading the selected projects for the run configuration", (Throwable)e);
            projectNamesList = Collections.emptyList();
        }
        List<IMuleProject> initialSelection = this.getProjects(projectNamesList);
        this.projectChooser.setCheckedProjects(initialSelection);
    }

    private List<IMuleProject> getProjects(List<String> projectNamesList) {
        LinkedList<IMuleProject> initialSelection = new LinkedList<IMuleProject>();
        for (String name : projectNamesList) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            try {
                if (!CoreUtils.hasMuleNature((IProject)project)) continue;
                initialSelection.add(MuleRuntime.create((IProject)project));
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)("There was a problem evaluating if the project " + project.getName() + " is a Mule project"), (Throwable)e);
            }
        }
        return initialSelection;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        LinkedList<String> selectedProjectNames = new LinkedList<String>();
        List selection = this.projectChooser.getCheckedProjects();
        for (IMuleProject iMuleProject : selection) {
            selectedProjectNames.add(iMuleProject.getName());
        }
        configuration.setAttribute("mule-project-names", selectedProjectNames);
        selectedProjectNames.stream().findFirst().ifPresent(p -> configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, p));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("mule-project-names", Collections.emptyList());
    }

    public void setPropertyChangeListener(IPropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "mule-project-names", null, null));
    }

    public void dispose() {
    }
}

