/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.launch;

import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.runtime.ui.RuntimeUiUtils;

public class MuleRuntimeLaunchShortcut
implements ILaunchShortcut {
    private String launchType;

    public MuleRuntimeLaunchShortcut(String launchType) {
        this.launchType = launchType;
    }

    public MuleRuntimeLaunchShortcut() {
        this("org.mule.tooling.runtime.muleServerLaunchType");
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IProject project;
            IMuleProject muleProject;
            Object first = ((IStructuredSelection)selection).getFirstElement();
            if (first instanceof IJavaElement) {
                IJavaElement el = (IJavaElement)first;
                first = el.getResource();
            }
            if (first instanceof IResource && (muleProject = MuleRuntime.create((IProject)(project = ((IResource)first).getProject()))) != null) {
                this.launch(muleProject, mode);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        FileEditorInput fileEditorInput;
        IProject project;
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof FileEditorInput && (project = (fileEditorInput = (FileEditorInput)editorInput).getFile().getProject()) != null) {
            this.launch(project, mode);
        }
    }

    protected void launch(IMuleProject muleProject, String mode) {
        Optional<ILaunchConfiguration> maybeConfig = RuntimeUiUtils.findLaunchConfiguration(muleProject, this.getLaunchType());
        maybeConfig.ifPresent(config -> DebugUITools.launch((ILaunchConfiguration)config, (String)mode));
    }

    protected String getLaunchType() {
        return this.launchType;
    }

    protected void launch(IProject project, String mode) {
        Optional<ILaunchConfiguration> maybeConfig = RuntimeUiUtils.findLaunchConfiguration(project, this.getLaunchType());
        maybeConfig.ifPresent(config -> DebugUITools.launch((ILaunchConfiguration)config, (String)mode));
    }
}

