/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.mule.tooling.runtime.ui.Activator;

public class MuleLaunchTabGroup
extends AbstractLaunchConfigurationTabGroup {
    private static final String ORDER_HIGH_VALUE = "~";
    private static final String ATT_CLASS = "class";
    private static final String ATT_ORDER = "order";
    private static final String LAUNCH_TABS_EXTENSION_POINT_ID = "org.mule.tooling.runtime.ui.launchTabs";
    private static List<ILaunchConfigurationTab> contributedTabs;

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationTabs();
        this.setTabs(tabs);
    }

    public String getLaunchTabsExtensionPointId() {
        return LAUNCH_TABS_EXTENSION_POINT_ID;
    }

    protected ILaunchConfigurationTab[] getLaunchConfigurationTabs() {
        ArrayList<ILaunchConfigurationTab> contributedTabs = new ArrayList<ILaunchConfigurationTab>(this.getContributedTabs());
        List<AbstractLaunchConfigurationTab> staticTabs = Arrays.asList(new JavaArgumentsTab(), new JavaJRETab(), new EnvironmentTab(), new CommonTab());
        contributedTabs.addAll(staticTabs);
        return contributedTabs.toArray(new ILaunchConfigurationTab[0]);
    }

    protected List<ILaunchConfigurationTab> getContributedTabs() {
        if (contributedTabs == null) {
            contributedTabs = this.initializeTabs();
        }
        return contributedTabs;
    }

    protected List<ILaunchConfigurationTab> initializeTabs() {
        IConfigurationElement[] configurationElements;
        ArrayList<TabExtension> tabExtensions = new ArrayList<TabExtension>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.getLaunchTabsExtensionPointId());
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String order = configurationElement.getAttribute(ATT_ORDER);
                ILaunchConfigurationTab tab = (ILaunchConfigurationTab)ILaunchConfigurationTab.class.cast(configurationElement.createExecutableExtension(ATT_CLASS));
                tabExtensions.add(new TabExtension(order == null ? ORDER_HIGH_VALUE : order, tab));
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.mule.tooling.runtime.ui", e.getMessage(), (Throwable)e));
            }
            ++n2;
        }
        Collections.sort(tabExtensions);
        return this.collectTabs(tabExtensions);
    }

    private List<ILaunchConfigurationTab> collectTabs(ArrayList<TabExtension> tabExtensions) {
        ArrayList<ILaunchConfigurationTab> tabs = new ArrayList<ILaunchConfigurationTab>();
        for (TabExtension tabExtension : tabExtensions) {
            tabs.add(tabExtension.getTab());
        }
        return tabs;
    }

    private static class TabExtension
    implements Comparable<TabExtension> {
        private String order;
        private ILaunchConfigurationTab tab;

        TabExtension(String order, ILaunchConfigurationTab tab) {
            this.order = order;
            this.tab = tab;
        }

        public ILaunchConfigurationTab getTab() {
            return this.tab;
        }

        @Override
        public int compareTo(TabExtension o) {
            return this.order.compareTo(o.order);
        }
    }
}

