/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.launch;

import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.runtime.ui.RuntimeUiUtils;

public class CustomMuleRuntimeLaunchShortcut
implements ILaunchShortcut {
    private String launchType;

    public CustomMuleRuntimeLaunchShortcut(String launchType) {
        this.launchType = launchType;
    }

    public CustomMuleRuntimeLaunchShortcut() {
        this("org.mule.tooling.runtime.muleServerLaunchType");
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            if (first instanceof IJavaElement) {
                IJavaElement el = (IJavaElement)first;
                first = el.getResource();
            }
            if (first instanceof IResource) {
                IProject project = ((IResource)first).getProject();
                this.openConfiguration(mode, project);
            }
        }
    }

    private void openConfiguration(String mode, IProject project) {
        IMuleProject muleProject = MuleRuntime.create((IProject)project);
        if (muleProject == null) {
            return;
        }
        Optional<ILaunchConfiguration> maybeConfig = RuntimeUiUtils.findLaunchConfiguration(muleProject, this.getLaunchType());
        maybeConfig.ifPresent(config -> this.openConfigDialog((ILaunchConfiguration)config, mode));
    }

    private void openConfigDialog(ILaunchConfiguration config, String mode) {
        ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)config, (String)mode);
        DebugUITools.openLaunchConfigurationDialog((Shell)this.getActiveShell(), (ILaunchConfiguration)config, (String)launchGroup.getIdentifier(), null);
    }

    private Shell getActiveShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void launch(IEditorPart editor, String mode) {
        FileEditorInput fileEditorInput;
        IProject project;
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof FileEditorInput && (project = (fileEditorInput = (FileEditorInput)editorInput).getFile().getProject()) != null) {
            this.openConfiguration(mode, project);
        }
    }

    protected String getLaunchType() {
        return this.launchType;
    }

    protected void launch(IProject project, String mode) {
        Optional<ILaunchConfiguration> maybeConfig = RuntimeUiUtils.findLaunchConfiguration(project, this.getLaunchType());
        maybeConfig.ifPresent(config -> this.openConfiguration(mode, project));
    }
}

