/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.runtime.launch.MuleProjectLaunchHolder;
import org.mule.tooling.runtime.launch.RuntimeUtils;
import org.mule.tooling.ui.launchConfiguration.extensible.LaunchConfigPartExtension;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;
import org.mule.tooling.ui.widgets.util.QuestionDialog;

public class ClearApplicationDataComponent
implements LaunchConfigPartExtension {
    public static final String CLEAR_DATA = "clear_data";
    private FieldEditor clearDataFieldEditor;
    private PreferenceStore store;
    private List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();

    public Control createControl(Composite parent) {
        Composite comp2 = new Composite(parent, 0);
        comp2.setLayout((Layout)new GridLayout(1, false));
        this.clearDataFieldEditor = new RadioGroupFieldEditor(CLEAR_DATA, "Clear Application Data:", 3, (String[][])new String[][]{{"Prompt", MuleStudioPreferencePage.ActionDialogState.PROMPT.name()}, {"Always", MuleStudioPreferencePage.ActionDialogState.ALWAYS.name()}, {"Never", MuleStudioPreferencePage.ActionDialogState.NEVER.name()}}, comp2, true);
        this.store = new PreferenceStore();
        this.clearDataFieldEditor.setPreferenceStore((IPreferenceStore)this.store);
        this.fieldEditors.add(this.clearDataFieldEditor);
        return comp2;
    }

    public void runPreLaunchConfigActions(ILaunchConfiguration configuration) {
        try {
            this.clearApplicationDataIfNeeded(configuration);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem clearing application data for applications", (Throwable)e);
        }
    }

    private void clearApplicationDataIfNeeded(ILaunchConfiguration configuration) throws CoreException {
        String clearDataString = configuration.getAttribute(CLEAR_DATA, MuleStudioPreferencePage.ActionDialogState.NEVER.name());
        MuleStudioPreferencePage.ActionDialogState clearDataState = MuleStudioPreferencePage.ActionDialogState.valueOf((String)clearDataString);
        if (clearDataState.prompt()) {
            QuestionDialog dialog = QuestionDialog.show((String)"Clear Application Data", (String)"Do you want to clear the application data?\n\nNote: You can also change this setting in the 'Run Configuration...' dialog.", (String)"Remember decision", null, null);
            if (dialog.getStatus()) {
                this.doClearApplicationData(configuration);
            }
            if (dialog.getToggleState()) {
                String value = dialog.getStatus() ? MuleStudioPreferencePage.ActionDialogState.ALWAYS.name() : MuleStudioPreferencePage.ActionDialogState.NEVER.name();
                ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                workingCopy.setAttribute(CLEAR_DATA, value);
                workingCopy.doSave();
            }
        } else if (MuleStudioPreferencePage.ActionDialogState.ALWAYS.equals((Object)clearDataState)) {
            this.doClearApplicationData(configuration);
        }
    }

    private void doClearApplicationData(ILaunchConfiguration configuration) throws CoreException {
        List muleProjectNames = configuration.getAttribute("mule-project-names", new ArrayList());
        MuleProjectLaunchHolder holder = new MuleProjectLaunchHolder(muleProjectNames);
        for (IMuleProject muleProject : holder.getAllLaunchProjects()) {
            RuntimeUtils.deleteApplicationDataFolder((IMuleProject)muleProject);
        }
    }

    public void runPostLaunchConfigActions(ILaunchConfiguration configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String state = configuration.getAttribute(CLEAR_DATA, MuleStudioPreferencePage.ActionDialogState.NEVER.name());
            this.store.setValue(CLEAR_DATA, state);
            this.clearDataFieldEditor.load();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.clearDataFieldEditor.store();
        String preferenceName = this.clearDataFieldEditor.getPreferenceName();
        IPreferenceStore preferenceStore = this.clearDataFieldEditor.getPreferenceStore();
        String state = MuleStudioPreferencePage.ActionDialogState.fromPreference((IPreferenceStore)preferenceStore, (String)preferenceName).name();
        configuration.setAttribute(CLEAR_DATA, state);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void setPropertyChangeListener(IPropertyChangeListener propertyChangeListener) {
        for (FieldEditor fieldEditor : this.fieldEditors) {
            fieldEditor.setPropertyChangeListener(propertyChangeListener);
        }
    }

    public void dispose() {
    }
}

