/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.installer;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.mule.tooling.runtime.ui.Activator;
import org.mule.tooling.ui.widgets.p2.InstallerService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RuntimeInstaller {
    private static final String LATEST_VERSION = "0.0.0";
    private static final String RUNTIMES_UPDATE_SITE_URL = "http://studio.mulesoft.org/r4/studio-runtimes";
    private final String version;
    private InstallerService installerService;

    public static RuntimeInstaller create(String version) {
        return new RuntimeInstaller(version, new InstallerService(RUNTIMES_UPDATE_SITE_URL, RuntimeInstaller.getProvisioningAgent()));
    }

    private static IProvisioningAgent getProvisioningAgent() {
        return (IProvisioningAgent)RuntimeInstaller.getService(IProvisioningAgent.SERVICE_NAME);
    }

    private static Object getService(String name) {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference reference = context.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = context.getService(reference);
        context.ungetService(reference);
        return result;
    }

    public RuntimeInstaller(String version, InstallerService installerService) {
        this.version = version;
        this.installerService = installerService;
    }

    private void reload(IProgressMonitor monitor) {
        try {
            this.installerService.reload(monitor);
        }
        catch (ProvisionException e) {
            Activator.getDefault().logError("There was a problem loading the repository located at: http://studio.mulesoft.org/r4/studio-runtimes", e);
        }
    }

    public boolean isRuntimeAvailable(IProgressMonitor monitor) throws ProvisionException {
        monitor.beginTask("Searching for runtime " + this.version, 100);
        monitor.worked(10);
        try {
            boolean hasFeature;
            boolean bl = hasFeature = this.installerService.hasFeature(this.buildFeatureId(), (IProgressMonitor)new SubProgressMonitor(monitor, 90));
            return bl;
        }
        catch (ProvisionException provisionException) {
            boolean hasFeature;
            this.reload((IProgressMonitor)new SubProgressMonitor(monitor, 40));
            boolean bl = hasFeature = this.installerService.hasFeature(this.buildFeatureId(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public void open() {
        this.installerService.install(this.buildFeatureId(), LATEST_VERSION, (IProgressMonitor)new NullProgressMonitor());
    }

    private String buildFeatureId() {
        return MessageFormat.format("org.mule.tooling.extension.server.{0}.ee.feature.group", this.version);
    }
}

