/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.contextmenu;

import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.IContextMenuProvider;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.runtime.launch.RuntimeUtils;
import org.mule.tooling.runtime.ui.contextmenu.DebugProjectAction;
import org.mule.tooling.runtime.ui.contextmenu.RunProjectAction;
import org.mule.tooling.runtime.ui.contextmenu.StopProjectAction;

public class RuntimeContextMenuProvider
implements IContextMenuProvider<MessageFlowNode> {
    public void addActions(IMenuManager manager, IMuleProject project, Optional<MessageFlowNode> maybeSelectedElement) {
        try {
            this.doAddActions(manager, project);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"There was a problem creating the run/debug actions for the canvas' context menu", (Throwable)e);
        }
    }

    private void doAddActions(IMenuManager manager, IMuleProject project) throws CoreException {
        if (this.isProperEditor()) {
            IContributionItem[] items = manager.getItems();
            if (items.length > 0) {
                String firstId = items[0].getId();
                if (!RuntimeUtils.isServerAlreadyRunningThisApp((IMuleProject)project)) {
                    manager.insertBefore(firstId, (IAction)new DebugProjectAction(project));
                    manager.insertBefore("org.mule.tooling.runtime.ui.contextmenu.debug", (IAction)new RunProjectAction(project));
                } else {
                    manager.insertBefore(firstId, (IAction)new StopProjectAction(project));
                }
            } else if (!RuntimeUtils.isServerAlreadyRunningThisApp((IMuleProject)project)) {
                manager.add((IAction)new RunProjectAction(project));
                manager.add((IAction)new DebugProjectAction(project));
            } else {
                manager.add((IAction)new StopProjectAction(project));
            }
        }
    }

    private boolean isProperEditor() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = activePage.getActiveEditor();
        return editor != null && editor.getClass() == MultiPageMessageFlowEditor.class;
    }
}

