/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui.contextmenu;

import java.util.List;
import java.util.Optional;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.runtime.ui.MuleRuntimeImages;
import org.mule.tooling.runtime.ui.RuntimeUiUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class DebugProjectAction
extends Action {
    public static final String ID = "org.mule.tooling.runtime.ui.contextmenu.debug";
    private IMuleProject muleProject;

    public DebugProjectAction(IMuleProject muleProject) {
        super("Debug project " + muleProject.getName(), MuleRuntimeImages.getImageDescriptor("icons/launcher/debug.png"));
        this.muleProject = muleProject;
    }

    public String getId() {
        return ID;
    }

    public void run() {
        AnalyticsRecordsFactory.single((String)Events.DEBUG_MULE_APPLICATION, (String[])new String[]{"from", "canvas", "runtimeVersion", this.muleProject.getServerDefinition().getLabel(), "debuggerVersion", this.muleProject.getServerDefinition().getDebuggerVersion()}).track();
        List<String> muleLaunchConfigTypes = RuntimeUiUtils.getMuleLaunchConfigTypes(this.muleProject);
        if (muleLaunchConfigTypes == null || muleLaunchConfigTypes.isEmpty()) {
            WidgetUtils.showException((String)"Unable to debug project", (String)("Cannot debug project '" + this.muleProject.getName() + "'. The project may have classpath issues or the workspace may be corrupt."));
        } else {
            Optional<ILaunchConfiguration> maybeConfig = RuntimeUiUtils.findLaunchConfiguration(this.muleProject, muleLaunchConfigTypes.get(0));
            maybeConfig.ifPresent(c -> DebugUITools.launch((ILaunchConfiguration)c, (String)"debug"));
        }
    }
}

