/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationSelectionDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.runtime.controller.MuleControllerHelper;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class RuntimeUiUtils {
    public static final String ORG_MULE = "org.mule";
    private static Map<String, ImageDescriptor> configToImageMap = new HashMap<String, ImageDescriptor>();

    public static Optional<ILaunchConfiguration> findLaunchConfiguration(IMuleProject muleProject, ILaunchConfigurationType configType) {
        IProject project = muleProject.getProject();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        try {
            LaunchConfigurationSelectionDialog launchConfigSelectionDialog;
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                List projectNameList = config.getAttribute("mule-project-names", Collections.emptyList());
                if (projectNameList.stream().anyMatch(candidateProject -> candidateProject.equals(project.getName()))) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
            if (candidateConfigs.isEmpty()) {
                return Optional.ofNullable(RuntimeUiUtils.createConfiguration(muleProject, configType));
            }
            int candidateCount = candidateConfigs.size();
            if (candidateCount == 1) {
                ILaunchConfiguration iLaunchConfiguration = (ILaunchConfiguration)candidateConfigs.get(0);
                return Optional.ofNullable(RuntimeUiUtils.migrate(muleProject, iLaunchConfiguration));
            }
            if (candidateCount > 1 && (launchConfigSelectionDialog = new LaunchConfigurationSelectionDialog(Display.getCurrent().getActiveShell(), candidateConfigs)).open() == 0) {
                ILaunchConfiguration iLaunchConfiguration = (ILaunchConfiguration)launchConfigSelectionDialog.getResult()[0];
                return Optional.ofNullable(RuntimeUiUtils.migrate(muleProject, iLaunchConfiguration));
            }
        }
        catch (CoreException e) {
            MuleUIPlugin.openError((Shell)RuntimeUiUtils.getShell(), (IStatus)e.getStatus());
        }
        return Optional.empty();
    }

    private static ILaunchConfiguration migrate(IMuleProject muleProject, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ILaunchConfiguration retVal = iLaunchConfiguration;
        ArrayList<String> projectNameList = iLaunchConfiguration.getAttribute("mule-project-names", Collections.emptyList());
        String serverId = iLaunchConfiguration.getAttribute("launch_mule_server_version", null);
        ILaunchConfigurationWorkingCopy workingCopy = iLaunchConfiguration.getWorkingCopy();
        if (projectNameList == null && serverId == null) {
            projectNameList = new ArrayList<String>();
            projectNameList.add(muleProject.getName());
            workingCopy.setAttribute("mule-project-names", projectNameList);
            workingCopy.setAttribute("launch_mule_server_version", muleProject.getServerDefinition().getId());
            retVal = workingCopy.doSave();
        }
        return retVal;
    }

    private static ILaunchConfiguration createConfiguration(IMuleProject muleProject, ILaunchConfigurationType configType) {
        try {
            String projectName = muleProject.getName();
            ILaunchConfigurationWorkingCopy launchConfigWorkingCopy = configType.newInstance(null, RuntimeUiUtils.getLaunchManager().generateLaunchConfigurationName(projectName));
            launchConfigWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
            ArrayList<String> projectNameList = new ArrayList<String>();
            projectNameList.add(projectName);
            launchConfigWorkingCopy.setAttribute("mule-project-names", projectNameList);
            launchConfigWorkingCopy.setAttribute("launch_mule_server_version", muleProject.getServerDefinition().getId());
            launchConfigWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, MuleControllerHelper.getInitialVMArguments().stream().collect(Collectors.joining(" ")));
            return launchConfigWorkingCopy.doSave();
        }
        catch (CoreException e) {
            MuleUIPlugin.openError((Shell)RuntimeUiUtils.getShell(), (IStatus)e.getStatus());
            return null;
        }
    }

    public static ILaunchConfigurationType getConfigurationType(String type) {
        return RuntimeUiUtils.getLaunchManager().getLaunchConfigurationType(type);
    }

    protected static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Optional<ILaunchConfiguration> findLaunchConfiguration(IMuleProject muleProject, String launchType) {
        return RuntimeUiUtils.findLaunchConfiguration(muleProject, RuntimeUiUtils.getConfigurationType(launchType));
    }

    public static Optional<ILaunchConfiguration> findLaunchConfiguration(IProject project, String launchType) {
        return RuntimeUiUtils.findLaunchConfiguration(MuleRuntime.create((IProject)project), RuntimeUiUtils.getConfigurationType(launchType));
    }

    public static List<String> getMuleLaunchConfigTypes(IMuleProject muleProject) {
        String[] applicableConfigurationTypes;
        ArrayList<String> configTypes = new ArrayList<String>();
        LaunchConfigurationManager launchConfigurationManager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        String[] stringArray = applicableConfigurationTypes = launchConfigurationManager.getApplicableConfigurationTypes((IResource)muleProject.getProject());
        int n = applicableConfigurationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String configType = stringArray[n2];
            if (configType.startsWith(ORG_MULE)) {
                configTypes.add(configType);
            }
            ++n2;
        }
        return configTypes;
    }

    public static ImageDescriptor getImageDescriptorForConfigType(String configType) {
        if (!configToImageMap.containsKey(configType)) {
            List launchShortcuts = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchShortcuts();
            for (LaunchShortcutExtension launchShortcutExtension : launchShortcuts) {
                if (!launchShortcutExtension.getAssociatedConfigurationTypes().contains(configType)) continue;
                configToImageMap.put(configType, launchShortcutExtension.getImageDescriptor());
                break;
            }
        }
        return configToImageMap.get(configType);
    }

    public static void launchMuleProject(IMuleProject muleProject) {
        List<String> muleLaunchConfigTypes = RuntimeUiUtils.getMuleLaunchConfigTypes(muleProject);
        if (muleLaunchConfigTypes.isEmpty()) {
            WidgetUtils.showException((String)"Unable to run project", (String)("Cannot run project '" + muleProject.getName() + "'. The project may have classpath issues or the workspace may be corrupt."));
        } else {
            Optional<ILaunchConfiguration> maybeConfig = RuntimeUiUtils.findLaunchConfiguration(muleProject, muleLaunchConfigTypes.get(0));
            maybeConfig.ifPresent(config -> DebugUITools.launch((ILaunchConfiguration)config, (String)"run"));
        }
    }
}

