/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.runtime.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.runtime.MuleRuntimePlugin;
import org.mule.tooling.runtime.events.IMuleProjectsLaunchListener;
import org.mule.tooling.runtime.events.MuleRuntimeEventTypes;
import org.mule.tooling.runtime.launch.LaunchesListenerAdapter;
import org.mule.tooling.runtime.ui.Activator;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MuleRuntimeApplicationListener
extends LaunchesListenerAdapter
implements IMuleProjectsLaunchListener {
    private static MuleRuntimeApplicationListener instance = new MuleRuntimeApplicationListener();
    private EventBusHelper helper = new EventBusHelper();

    public static MuleRuntimeApplicationListener getDefault() {
        return instance;
    }

    private MuleRuntimeApplicationListener() {
        this.helper.registerListener(MuleRuntimePlugin.getDefault().getEventBus(), MuleRuntimeEventTypes.ON_MULE_PROJECT_LAUNCH, (IEventHandler)this);
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void muleProjectsLaunched(ILaunch launch, IServerDefinition serverDefinition, List<IMuleProject> projects) {
        if (!MuleRuntimePlugin.getDefault().getMuleServersStateManager().hasStateManager(serverDefinition)) {
            try {
                Integer agentPort = Integer.valueOf(launch.getLaunchConfiguration().getAttribute("mule-agent-port", ""));
                String agentTokenAuth = launch.getLaunchConfiguration().getAttribute("mule-agent-token-auth", "");
                MuleRuntimePlugin.getDefault().getMuleServersStateManager().startApplicationsStateManager(serverDefinition, agentPort.intValue(), agentTokenAuth);
            }
            catch (NumberFormatException | CoreException e) {
                Activator.getDefault().logError("Error while registering application in application server state manager", e);
            }
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }
}

