/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.PlatformBackoffBarrier;
import com.mulesoft.mule.runtime.gw.analytics.backoff.AnalytictsBackoffConfigurationSupplier;
import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCaches;
import com.mulesoft.mule.runtime.gw.analytics.runnable.AnalyticsEventSenderRunnable;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.client.ApiPlatformClient;
import com.mulesoft.mule.runtime.gw.config.AnalyticsConfiguration;
import com.mulesoft.mule.runtime.gw.util.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class AnalyticsPollersManager {
    private BackoffSchedulerFactory schedulerFactory;
    private BackoffScheduler analyticsScheduler;
    private BackoffScheduler policyViolationsScheduler;
    private AnalyticsConfiguration configuration;
    private AnalyticsEventCaches cloudCaches;
    private ApiPlatformClient restClient;
    private BackoffConfiguration backoffConfiguration;

    public AnalyticsPollersManager(AnalyticsConfiguration configuration, AnalyticsEventCaches cloudCaches, ApiPlatformClient apiPlatformClient, BackoffSchedulerFactory schedulerFactory) {
        this.configuration = configuration;
        this.cloudCaches = cloudCaches;
        this.restClient = apiPlatformClient;
        this.schedulerFactory = schedulerFactory;
        this.backoffConfiguration = new AnalytictsBackoffConfigurationSupplier().get();
    }

    public void scheduleAnalyticsRunnable() {
        if (this.analyticsScheduler == null) {
            this.analyticsScheduler = this.schedulerFactory.create(Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("agw-analytics")));
            AnalyticsEventSenderRunnable runnable = new AnalyticsEventSenderRunnable(this.cloudCaches.getRegularEventsCache(), this.configuration.getAnalyticsEventsBatchSize(), this.restClient, this.backoffConfiguration, this.backoffBarrier());
            this.analyticsScheduler.scheduleWithFixedDelay((BackoffRunnable)runnable, this.analyticsSchedulerConfiguration());
        }
    }

    public void schedulePolicyViolationsRunnable() {
        if (this.policyViolationsScheduler == null) {
            this.policyViolationsScheduler = this.schedulerFactory.create(Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("agw-policy-violations")));
            AnalyticsEventSenderRunnable runnable = new AnalyticsEventSenderRunnable(this.cloudCaches.getViolationsEventsCache(), this.configuration.getAnalyticsEventsBatchSize(), this.restClient, this.backoffConfiguration, this.backoffBarrier());
            this.policyViolationsScheduler.scheduleWithFixedDelay((BackoffRunnable)runnable, this.policyViolationsSchedulerConfiguration());
        }
    }

    private BackoffBarrier backoffBarrier() {
        return new PlatformBackoffBarrier();
    }

    public SchedulingConfiguration analyticsSchedulerConfiguration() {
        int pushFreq = this.configuration.getPushFrequency();
        return SchedulingConfiguration.configuration((Period)Period.seconds((int)pushFreq), (Period)Period.seconds((int)pushFreq));
    }

    public SchedulingConfiguration policyViolationsSchedulerConfiguration() {
        int pushFreq = this.configuration.getPolicyViolationsPushFrequency();
        return SchedulingConfiguration.configuration((Period)Period.seconds((int)(pushFreq + 2)), (Period)Period.seconds((int)pushFreq));
    }

    public void shutdown() {
        this.analyticsScheduler.dispose();
        this.policyViolationsScheduler.dispose();
    }
}

