/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.installer;

import com.mulesoft.agent.exception.AgentInstallerException;
import com.mulesoft.agent.exception.RuntimeRestartException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.InstallerService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.exception.MuleException;

@Named(value="mule.agent.installer.service")
@Singleton
public class AgentInstallerService
extends ConfigurableAgentService
implements InstallerService {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MULE_AGENT_SETUP_JAR = "mule-agent-setup.jar";
    public static final String MULE_AGENT_PLUGIN = "mule-agent-plugin";
    public static final String MULE_AGENT_PLUGIN_JAR = "mule-agent-plugin.jar";
    @Inject
    private AdministrationService administrationService;

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>();
    }

    public void upgradeAgent(InputStream binary) {
        if (binary == null) {
            throw new IllegalArgumentException("Request needs to specify a file to install");
        }
        try {
            URL thisJarPath = AgentInstallerService.class.getProtectionDomain().getCodeSource().getLocation();
            File pluginsFolder = new File(thisJarPath.getPath()).getParentFile().getParentFile().getParentFile();
            File muleAgentPluginFolder = new File(thisJarPath.getPath()).getParentFile().getParentFile();
            URI tempDirNewAgentVersionPath = this.createTempDir(pluginsFolder.getPath());
            File tempDirNewAgentVersionFile = new File(tempDirNewAgentVersionPath);
            File file = new File(tempDirNewAgentVersionFile, File.separator + MULE_AGENT_SETUP_JAR);
            FileOutputStream stream = new FileOutputStream(file);
            stream.write(IOUtils.toByteArray((InputStream)binary));
            stream.close();
            JarFile jarFile = new JarFile(file);
            ZipEntry entry = jarFile.getEntry(MULE_AGENT_PLUGIN_JAR);
            if (entry == null) {
                throw new IllegalArgumentException("Agent could not be upgraded. Invalid file.");
            }
            InputStream zippedAgentEntry = jarFile.getInputStream(entry);
            File newAgent = new File(tempDirNewAgentVersionFile.getPath() + File.separator + MULE_AGENT_PLUGIN);
            newAgent.mkdir();
            this.unzip(newAgent.getPath(), zippedAgentEntry);
            file.delete();
            URI tempDirOldAgentVersionPath = this.createTempDir(pluginsFolder.getPath());
            File tempDirOldAgentVersionFile = new File(tempDirOldAgentVersionPath);
            FileUtils.copyDirectoryToDirectory((File)muleAgentPluginFolder, (File)tempDirOldAgentVersionFile);
            this.updateComponent(tempDirOldAgentVersionFile, tempDirNewAgentVersionFile, pluginsFolder.getPath());
            this.removeTempDir(tempDirNewAgentVersionPath);
            this.removeTempDir(tempDirOldAgentVersionPath);
            this.administrationService.restartRuntime();
        }
        catch (IOException e) {
            throw new AgentInstallerException("Agent could not be upgraded.", (Throwable)e);
        }
        catch (RuntimeRestartException e) {
            throw new AgentInstallerException("There was an error restarting the server.", (Throwable)e);
        }
    }

    private void updateComponent(File tempDirOldComponentFile, File tempDirNewComponentFile, String destPath) throws IOException {
        try {
            File[] newFiles;
            File[] oldFiles = tempDirOldComponentFile.listFiles();
            if (oldFiles != null) {
                for (File file : oldFiles) {
                    File oldJar = new File(destPath + File.separator + file.getName());
                    FileUtils.forceDelete((File)oldJar);
                }
            }
            if ((newFiles = tempDirNewComponentFile.listFiles()) != null) {
                for (File file : newFiles) {
                    File dest = new File(destPath);
                    if (file.isDirectory()) {
                        FileUtils.copyDirectoryToDirectory((File)file, (File)dest);
                        continue;
                    }
                    FileUtils.copyFileToDirectory((File)file, (File)dest);
                }
            }
        }
        catch (IOException e) {
            this.rollBack(tempDirOldComponentFile, tempDirNewComponentFile, destPath);
            throw new AgentInstallerException("Could not install component.", e.getCause());
        }
    }

    private void rollBack(File tempDirOldComponentFile, File tempDirNewComponentFile, String destPath) throws IOException {
        try {
            File[] newFiles;
            File[] oldFiles = tempDirOldComponentFile.listFiles();
            if (oldFiles != null) {
                for (File file : oldFiles) {
                    Files.move(file.toPath(), Paths.get(destPath, new String[0]), new CopyOption[0]);
                }
            }
            if ((newFiles = tempDirNewComponentFile.listFiles()) != null) {
                for (File file : newFiles) {
                    File installedJar = new File(destPath + file.getName());
                    installedJar.delete();
                }
            }
        }
        catch (IOException e) {
            throw new AgentInstallerException("Could not install component. System may be in an inconsistent state.", e.getCause());
        }
    }

    public static void verifyZipFilePaths(InputStream binary) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(binary);
        while ((entry = zis.getNextEntry()) != null) {
            Path namePath = Paths.get(entry.getName(), new String[0]);
            if (namePath.getRoot() != null) {
                throw new AgentInstallerException("Absolute paths are not allowed: " + namePath.toString());
            }
            if (!namePath.normalize().toString().startsWith("..")) continue;
            throw new AgentInstallerException("External paths are not allowed: " + namePath.toString());
        }
    }

    private void unzip(String destinationPath, InputStream binary) {
        try {
            ZipEntry entry;
            AgentInstallerService.verifyZipFilePaths(binary);
            int BUFFER = 2048;
            ZipInputStream zis = new ZipInputStream(binary);
            while ((entry = zis.getNextEntry()) != null) {
                String destinationFile = destinationPath + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    int count;
                    byte[] data = new byte[2048];
                    FileOutputStream fos = new FileOutputStream(destinationFile);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                    while ((count = zis.read(data, 0, 2048)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    continue;
                }
                File dir = new File(destinationFile);
                dir.mkdir();
            }
            zis.close();
        }
        catch (IOException e) {
            throw new AgentInstallerException("Could not unzip file.", e.getCause());
        }
    }

    private URI createTempDir(String destPath) throws IOException {
        try {
            Path path = Paths.get(destPath, new String[0]);
            URI uri = Files.createTempDirectory(path, "component-", new FileAttribute[0]).toUri();
            File dir = new File(uri);
            dir.setReadable(true, false);
            dir.setWritable(true, false);
            dir.setExecutable(true, false);
            return uri;
        }
        catch (Exception e) {
            LOGGER.error("Could not create temporary directory for component. Exception was: " + e.getMessage());
            throw new IOException();
        }
    }

    private void removeTempDir(URI path) {
        try {
            FileUtils.cleanDirectory((File)new File(path));
            Files.deleteIfExists(Paths.get(path));
        }
        catch (Exception e) {
            LOGGER.error("Could not remove temporary directory of component. Exception was: " + e.getMessage());
        }
    }
}

