/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.file.transport.actions;

import com.mulesoft.agent.file.transport.actions.ApplicationAction;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ApplicationService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentAction
extends ApplicationAction {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentAction.class);
    private final Path configurationFolderPath;

    DeploymentAction(Path path, Path configurationFolderPath) {
        super(path);
        this.configurationFolderPath = configurationFolderPath;
    }

    @Override
    public void execute(ApplicationService applicationService, AdministrationService administrationService) {
        try {
            Map<String, Map> configuration = this.getConfiguration(Optional.of(this.configurationFolderPath));
            applicationService.deploy(this.getApplicationName(), this.getActionResourceFilePath().toUri().toString(), configuration);
            this.cleanUp();
        }
        catch (Exception e) {
            LOGGER.error("Error performing deployment of {}. Cause: {}", (Object)this.getApplicationName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug("Error performing deployment of {}. Cause: {}", (Object)this.getApplicationName(), (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private void cleanUp() {
        try {
            Files.delete(this.getActionResourceFilePath());
        }
        catch (IOException e) {
            LOGGER.error("Could not delete {} ", (Object)this.getActionResourceFilePath(), (Object)e);
        }
    }
}

