/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.file.transport.actions;

import com.mulesoft.agent.file.transport.DeploymentConfigurationManager;
import com.mulesoft.agent.file.transport.actions.ApplicationAction;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ApplicationService;
import com.mulesoft.agent.services.MuleAgentService;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeConfigurationAction
extends ApplicationAction {
    private static final Logger LOGGER = LogManager.getLogger(ChangeConfigurationAction.class);
    private final Map<String, MuleAgentService> services;

    ChangeConfigurationAction(Path path, Map<String, MuleAgentService> services) {
        super(path);
        this.services = services;
    }

    @Override
    public void execute(ApplicationService applicationService, AdministrationService administrationService) {
        try {
            Map<String, Map> configuration = this.getConfiguration(Optional.empty());
            for (Map.Entry<String, Map> entry : configuration.entrySet()) {
                String componentId = entry.getKey();
                Map componentConfiguration = entry.getValue();
                this.applyConfiguration(componentId, componentConfiguration, administrationService);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error performing change configuration for {}. Cause: {}", (Object)this.getApplicationName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void applyConfiguration(String componentId, Map componentConfiguration, AdministrationService administrationService) {
        try {
            DeploymentConfigurationManager.newInstace().addComponentId(componentId).addConfiguration(componentConfiguration).addAdministrationService(administrationService).parse().update().restartService();
        }
        catch (Exception e) {
            LOGGER.error("Error performing change configuration for {} and component id {}. Cause: {}", (Object)this.getApplicationName(), (Object)componentId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

