/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.file.transport.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.file.transport.actions.ChangeConfigurationAction;
import com.mulesoft.agent.file.transport.actions.DeploymentAction;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ApplicationService;
import com.mulesoft.agent.services.MuleAgentService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public abstract class ApplicationAction {
    private static final String ARTIFACT_EXTENSION = "jar";
    private static final String JSON_EXTENSION = "json";
    private static final String YAML_EXTENSION = "yml";
    private static final Logger LOGGER = LogManager.getLogger(ApplicationAction.class);
    private final Path actionResourceFilePath;

    ApplicationAction(Path actionResourceFilePath) {
        this.actionResourceFilePath = actionResourceFilePath;
    }

    public static boolean isDeployed(ApplicationService applicationService, Path path) {
        return applicationService.getApplication(ApplicationAction.getApplicationName(path)) != null;
    }

    public static boolean isArtifact(Path path) {
        return ApplicationAction.kind(path) == FileKind.ARTIFACT;
    }

    public static boolean isConfiguration(Path path) {
        return ApplicationAction.kind(path) == FileKind.CONFIGURATION;
    }

    public static String getFileKind(Path path) {
        return ApplicationAction.kind(path).name();
    }

    private static Path getConfigurationFilePath(String applicationName, Path directoryPath) {
        Path jsonPath = directoryPath.resolve(String.format("%s.%s", applicationName, JSON_EXTENSION));
        Path yamlPath = directoryPath.resolve(String.format("%s.%s", applicationName, YAML_EXTENSION));
        boolean isJsonAvailable = jsonPath.toFile().exists();
        boolean isYamlAvailable = yamlPath.toFile().exists();
        if (isJsonAvailable && isYamlAvailable) {
            throw new IllegalStateException(String.format("Cannot use %s and %s configuration at the same time", JSON_EXTENSION, YAML_EXTENSION));
        }
        return isJsonAvailable ? jsonPath : yamlPath;
    }

    private static String getApplicationName(Path path) {
        return com.google.common.io.Files.getNameWithoutExtension((String)path.getFileName().toString());
    }

    private static FileKind kind(Path path) {
        FileKind kind;
        String extension;
        switch (extension = com.google.common.io.Files.getFileExtension((String)path.toString())) {
            case "jar": {
                kind = FileKind.ARTIFACT;
                break;
            }
            case "json": 
            case "yml": {
                kind = FileKind.CONFIGURATION;
                break;
            }
            default: {
                kind = FileKind.UNKNOWN;
            }
        }
        return kind;
    }

    public static ApplicationAction deploy(Path path, Path configurationPath) {
        return new DeploymentAction(path, configurationPath);
    }

    public static ApplicationAction configurationChange(Path path, Map<String, MuleAgentService> services) {
        return new ChangeConfigurationAction(path, services);
    }

    public abstract void execute(ApplicationService var1, AdministrationService var2);

    protected Path getActionResourceFilePath() {
        return this.actionResourceFilePath;
    }

    String getApplicationName() {
        return ApplicationAction.getApplicationName(this.actionResourceFilePath);
    }

    protected Map<String, Map> getConfiguration(Optional<Path> maybeAlternativeConfigurationDirectoryPath) {
        Map<String, Map> configuration = Collections.emptyMap();
        String applicationName = ApplicationAction.getApplicationName(this.actionResourceFilePath);
        Path configurationPath = ApplicationAction.getConfigurationFilePath(applicationName, maybeAlternativeConfigurationDirectoryPath.orElse(this.actionResourceFilePath.getParent()));
        if (!configurationPath.toFile().exists()) {
            configurationPath = ApplicationAction.getConfigurationFilePath(applicationName, this.actionResourceFilePath.getParent());
        }
        if (configurationPath.toFile().exists()) {
            LOGGER.info("Configuration file exists: {}", (Object)configurationPath.toAbsolutePath().toString());
            try {
                String content = new String(Files.readAllBytes(configurationPath), StandardCharsets.UTF_8);
                configuration = ConfigurationLoader.getLoader(configurationPath).load(content);
            }
            catch (IOException e) {
                LOGGER.error("Error reading configuration file {}", (Object)configurationPath, (Object)e);
            }
        }
        return configuration;
    }

    private static class ConfigurationLoaderException
    extends RuntimeException {
        ConfigurationLoaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class YamlConfigurationLoader
    implements ConfigurationLoader {
        private YamlConfigurationLoader() {
        }

        @Override
        public Map<String, Map> load(String content) {
            Yaml yaml = new Yaml();
            return (Map)yaml.loadAs(content, Map.class);
        }
    }

    private static class JsonConfigurationLoader
    implements ConfigurationLoader {
        private JsonConfigurationLoader() {
        }

        @Override
        public Map<String, Map> load(String content) {
            try {
                if (StringUtils.isEmpty((String)content)) {
                    return Collections.emptyMap();
                }
                ObjectMapper mapper = new ObjectMapper();
                return (Map)mapper.readValue(content, Map.class);
            }
            catch (JsonProcessingException e) {
                throw new ConfigurationLoaderException("Error parsing configuration", e);
            }
        }
    }

    public static interface ConfigurationLoader {
        public static ConfigurationLoader getLoader(Path path) {
            String extension;
            switch (extension = com.google.common.io.Files.getFileExtension((String)path.toString())) {
                case "json": {
                    return new JsonConfigurationLoader();
                }
                case "yml": {
                    return new YamlConfigurationLoader();
                }
            }
            throw new IllegalArgumentException("Configuration type not supported");
        }

        public Map<String, Map> load(String var1);
    }

    private static enum FileKind {
        ARTIFACT,
        CONFIGURATION,
        UNKNOWN;

    }
}

