/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.file.transport;

import com.google.common.base.Optional;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.exception.AgentException;
import com.mulesoft.agent.exception.AgentInitializationException;
import com.mulesoft.agent.file.transport.ConfigurationWatcher;
import com.mulesoft.agent.file.transport.DeploymentsWalker;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ApplicationService;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="file.agent.transport")
@Singleton
public class FileAgentTransport
implements AgentTransport<Request, Response> {
    private static final Logger LOGGER = LogManager.getLogger(FileAgentTransport.class);
    private final Injector injector;
    private final ApplicationService applicationService;
    private final AdministrationService administrationService;
    @Configurable(value="false")
    private boolean enabled;
    @Configurable(value="$MULE_HOME/deployments", type=Type.DYNAMIC)
    private String deployments;
    @Configurable(value="$MULE_HOME/deployments/conf", type=Type.DYNAMIC)
    private String configurations;
    private ScheduledExecutorService pool;
    private WatchService watcher;
    private Map<String, MuleAgentService> services;

    @Inject
    public FileAgentTransport(Injector injector, ApplicationService applicationService, AdministrationService administrationService) {
        this.injector = injector;
        this.applicationService = applicationService;
        this.administrationService = administrationService;
    }

    public Optional<Response> send(Request message) {
        return Optional.absent();
    }

    public void initialise() throws AgentInitializationException {
        try {
            this.pool = Executors.newSingleThreadScheduledExecutor();
            this.watcher = FileSystems.getDefault().newWatchService();
            this.services = (Map)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, MuleAgentService>>(){}));
        }
        catch (IOException e) {
            LOGGER.error("Could not initialise file transport", (Throwable)e);
            throw new AgentInitializationException("Could not initialise file transport", (Exception)e);
        }
    }

    public void start() {
        LOGGER.debug("Starting FileAgentTransport");
    }

    public void stop() {
        this.pool.shutdown();
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            LOGGER.error("Could not close watch service", (Throwable)e);
        }
    }

    public void dispose() {
        LOGGER.debug("Disposing FileAgentTransport");
    }

    public void enableIncomingRequests() throws AgentException {
        try {
            if (this.deployments == null) {
                LOGGER.error("Deployment directory is NULL.");
                return;
            }
            this.deployments = this.resolvePath(this.deployments);
            this.configurations = this.resolvePath(this.configurations);
            Path deploymentsDirectoryPath = Paths.get(this.deployments, new String[0]);
            Path configurationsDirectoryPath = Paths.get(this.configurations, new String[0]);
            this.createDirectoryIfDoesntExists(deploymentsDirectoryPath);
            this.createDirectoryIfDoesntExists(configurationsDirectoryPath);
            LOGGER.info("Running deployments walker");
            Files.walkFileTree(deploymentsDirectoryPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, new DeploymentsWalker(deploymentsDirectoryPath, configurationsDirectoryPath, this.applicationService, this.administrationService));
            this.pool.execute(new ConfigurationWatcher(configurationsDirectoryPath, this.watcher, this.applicationService, this.administrationService, this.services));
        }
        catch (IOException e) {
            LOGGER.error("Could not enable file transport", (Throwable)e);
            throw new AgentException("Could not enable file transport", (Exception)e);
        }
    }

    private String resolvePath(String path) throws AgentException {
        String resolved = path;
        if (path.startsWith("$MULE_HOME")) {
            String muleHome = System.getProperty("mule.home");
            if (muleHome != null) {
                resolved = path.replace("$MULE_HOME", muleHome);
            } else {
                LOGGER.error("$MULE_HOME not defined");
                throw new AgentException(String.format("$MULE_HOME not defined and used as part of the path: %s when configuring the file agent transport", path));
            }
        }
        return resolved;
    }

    private void createDirectoryIfDoesntExists(Path path) throws IOException {
        if (!path.toFile().exists()) {
            Files.createDirectory(path, new FileAttribute[0]);
            LOGGER.info("{} Directory created", (Object)path);
        } else {
            LOGGER.info("{} Directory already exists", (Object)path);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

