/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.file.transport;

import com.mulesoft.agent.file.transport.actions.ApplicationAction;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ApplicationService;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class DeploymentsWalker
extends SimpleFileVisitor<Path> {
    private final Path root;
    private final Path configurationPath;
    private final ApplicationService applicationService;
    private final AdministrationService administrationService;

    DeploymentsWalker(Path root, Path configurationPath, ApplicationService applicationService, AdministrationService administrationService) {
        this.root = root;
        this.configurationPath = configurationPath;
        this.applicationService = applicationService;
        this.administrationService = administrationService;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return this.root.equals(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (ApplicationAction.isArtifact(file) && !ApplicationAction.isDeployed(this.applicationService, file)) {
            ApplicationAction.deploy(file, this.configurationPath).execute(this.applicationService, this.administrationService);
        }
        return FileVisitResult.CONTINUE;
    }
}

