/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.file.transport;

import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ComponentOperationException;
import com.mulesoft.agent.exception.InvalidConfigurationException;
import com.mulesoft.agent.exception.NoSuchComponentException;
import com.mulesoft.agent.services.AdministrationService;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentConfigurationManager {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentConfigurationManager.class);
    private String componentId;
    private Optional<Map<String, Map<Object, Object>>> configuration;
    private AdministrationService administrationService;
    private Map<String, ApplicationConfiguration> parsedConfiguration = new HashMap<String, ApplicationConfiguration>();
    private String applicationName;

    private DeploymentConfigurationManager() {
    }

    public static DeploymentConfigurationManager newInstace() {
        return new DeploymentConfigurationManager();
    }

    public DeploymentConfigurationManager addComponentId(String componentId) {
        this.componentId = componentId;
        return this;
    }

    public DeploymentConfigurationManager addConfiguration(Map<String, Map<Object, Object>> configuration) {
        this.configuration = Optional.ofNullable(configuration);
        return this;
    }

    public DeploymentConfigurationManager addAdministrationService(AdministrationService administrationService) {
        this.administrationService = administrationService;
        return this;
    }

    public DeploymentConfigurationManager parse() throws NoSuchComponentException, InvalidConfigurationException {
        if (!this.configuration.isPresent()) {
            return this;
        }
        try {
            ApplicationConfiguration applicationConfiguration = this.administrationService.parseApplicationConfiguration(this.componentId, this.configuration.get());
            this.applicationName = applicationConfiguration.getApplicationName();
            this.parsedConfiguration.put(this.componentId, applicationConfiguration);
        }
        catch (NoSuchElementException e) {
            LOGGER.error("Component {} does not exist", (Object)this.componentId);
            throw new NoSuchComponentException(e.getMessage());
        }
        catch (NoSuchFieldException e) {
            String message = String.format("Component %s does not support deployment configuration", this.componentId);
            LOGGER.error(message);
            throw new InvalidConfigurationException(message);
        }
        return this;
    }

    public DeploymentConfigurationManager update() throws NoSuchComponentException, NoSuchFieldException, ComponentOperationException {
        if (!this.configuration.isPresent()) {
            return this;
        }
        for (Map.Entry<String, ApplicationConfiguration> entry : this.parsedConfiguration.entrySet()) {
            LOGGER.info("Parsing config for: {}", (Object)entry.getKey());
            try {
                this.administrationService.updateApplicationConfiguration(entry.getKey(), entry.getValue(), this.applicationName);
            }
            catch (NoSuchElementException e) {
                String message = String.format("Invalid reference in configuration for application '%s': Component '%s' does not exist", this.applicationName, entry.getKey());
                LOGGER.warn(message);
                throw new NoSuchComponentException(message);
            }
            catch (NoSuchFieldException e) {
                String message = String.format("Invalid reference in configuration for application '%s': Component '%s' does not allow dynamic application configuration", this.applicationName, entry.getKey());
                LOGGER.warn(message);
                throw new NoSuchFieldException(message);
            }
            catch (AgentEnableOperationException e) {
                LOGGER.error("Unable to update configuration for application: '{}' component: '{}'", (Object)this.applicationName, (Object)entry.getKey(), (Object)e);
            }
        }
        return this;
    }

    public void restartService() throws AgentEnableOperationException {
        this.administrationService.switchComponent(this.componentId, false);
        this.administrationService.switchComponent(this.componentId, true);
    }

    protected Optional<Map<String, Map<Object, Object>>> getConfiguration() {
        return this.configuration;
    }

    protected AdministrationService getAdministrationService() {
        return this.administrationService;
    }

    public Map<String, ApplicationConfiguration> getParsedConfiguration() {
        return this.parsedConfiguration;
    }

    String getComponentId() {
        return this.componentId;
    }

    String getApplicationName() {
        return this.applicationName;
    }
}

