/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.file.transport;

import com.mulesoft.agent.file.transport.actions.ApplicationAction;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ApplicationService;
import com.mulesoft.agent.services.MuleAgentService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationWatcher
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(ConfigurationWatcher.class);
    private final Path root;
    private final WatchService watcher;
    private final ApplicationService applicationService;
    private final AdministrationService administrationService;
    private final Map<String, MuleAgentService> services;

    ConfigurationWatcher(Path root, WatchService watcher, ApplicationService applicationService, AdministrationService administrationService, Map<String, MuleAgentService> services) {
        this.root = root;
        this.watcher = watcher;
        this.applicationService = applicationService;
        this.administrationService = administrationService;
        this.services = services;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleConfigurationChanges(Path child, WatchEvent.Kind<?> kind) {
        for (Path configurationPath : this.getConfigurations(child)) {
            LOGGER.debug("Evaluating: {}", (Object)configurationPath);
            if (this.isChangeConfigurationRequired(configurationPath, kind)) {
                ApplicationAction.configurationChange(configurationPath, this.services).execute(this.applicationService, this.administrationService);
                continue;
            }
            LOGGER.debug("Skipping: path '{}' fileKind '{}' eventKind '{}'. Reason: No configuration changes are required", (Object)configurationPath, (Object)ApplicationAction.getFileKind(configurationPath), kind);
        }
    }

    private List<Path> getConfigurations(Path child) {
        File childFile = child.toFile();
        ArrayList<Path> configurations = new ArrayList<Path>();
        if (childFile.isFile()) {
            configurations.add(child);
        } else {
            configurations.addAll(Arrays.stream(childFile.listFiles()).map(File::toPath).collect(Collectors.toList()));
        }
        return configurations;
    }

    private void registerWatcher() {
        try {
            this.root.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            LOGGER.error("Watcher cannot be registered for {}", (Object)this.root, (Object)e);
        }
    }

    private boolean isChangeConfigurationRequired(Path path, WatchEvent.Kind<?> kind) {
        return ApplicationAction.isConfiguration(path) && kind == StandardWatchEventKinds.ENTRY_MODIFY;
    }
}

