/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.logging;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class SuppressingLogger {
    private final Logger logger;
    private final long suppressionDuration;
    private final String suppressionSuffix;
    private final AtomicLong lastRejectionLog = new AtomicLong(-1L);

    public SuppressingLogger(Logger logger, long suppressionDuration, String suppressionSuffix) {
        this.logger = logger;
        this.suppressionDuration = suppressionDuration;
        this.suppressionSuffix = suppressionSuffix;
    }

    public void log(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(message);
        } else {
            this.lastRejectionLog.updateAndGet(t -> {
                long now = System.currentTimeMillis();
                if (t < now - this.suppressionDuration) {
                    this.logger.warn("{}. {}", (Object)message, (Object)this.suppressionSuffix);
                    return now;
                }
                return t;
            });
        }
    }
}

