/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.service.scheduler.internal.FutureUtils;

abstract class AbstractDelegatedScheduledFuture<V>
implements ScheduledFuture<V> {
    protected final RunnableFuture<V> task;

    protected AbstractDelegatedScheduledFuture(RunnableFuture<V> task) {
        this.task = task;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.task.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return FutureUtils.isCancelled(this.task);
    }

    @Override
    public boolean isDone() {
        return FutureUtils.isDone(this.task);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return FutureUtils.get(this.task);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return FutureUtils.get(this.task, timeout, unit);
    }
}

