/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.views;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.templatesrepo.views.StudioBrowser;

public class TemplatesRepositoryView {
    private static final double SCREEN_SIZE_PERCENTAGE = 0.8;
    public static final String TITLE = "Library";
    protected final Shell parent;
    protected final String initialUrl;
    protected Shell shell;

    public TemplatesRepositoryView(Shell parent, String initialUrl) {
        this.parent = parent;
        this.initialUrl = initialUrl;
    }

    public void open() {
        this.shell = new Shell(this.parent, 1264);
        Point initialSize = this.getInitialSize();
        this.shell.setSize(initialSize);
        this.shell.setLocation(this.getInitialLocation(initialSize));
        this.createContents((Composite)this.shell);
        this.shell.open();
    }

    public void close() {
        this.shell.close();
        this.shell.dispose();
    }

    protected Point getInitialSize() {
        Rectangle clientArea = this.getActiveClientArea();
        int repoWidth = (int)((double)clientArea.width * 0.8);
        int repoHeight = (int)((double)clientArea.height * 0.8);
        return new Point(repoWidth, repoHeight);
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle clientArea = this.getActiveClientArea();
        double centerWidth = (double)clientArea.width * 0.5 + (double)clientArea.x;
        double centerHeight = (double)clientArea.height * 0.5 + (double)clientArea.y;
        int centerX = (int)(centerWidth - (double)initialSize.x * 0.5);
        int centerY = (int)(centerHeight - (double)initialSize.y * 0.5);
        return new Point(centerX, centerY);
    }

    protected Rectangle getActiveClientArea() {
        Monitor activeMonitor = this.getShell().getMonitor();
        Rectangle clientArea = activeMonitor.getClientArea();
        return clientArea;
    }

    protected Control createContents(Composite parent) {
        StudioBrowser browser = new StudioBrowser(parent);
        browser.setUrl(this.initialUrl);
        this.setTitle(TITLE);
        return parent;
    }

    protected void setTitle(String title) {
        this.getShell().setText(title);
    }

    protected Shell getShell() {
        return this.shell;
    }

    public void setFocus() {
        this.shell.forceActive();
        this.shell.setFocus();
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }
}

