/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.views;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.PlatformUrls;

public class TemplatesRepositoryErrorDialog
extends Dialog {
    protected final String errorMessage;
    protected final String title;

    public TemplatesRepositoryErrorDialog(Shell parentShell, String title, String errorMessage) {
        super(parentShell);
        this.title = title;
        this.errorMessage = errorMessage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.getShell().setText(this.title);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage(Display.getCurrent().getSystemImage(1));
        GridDataFactory.fillDefaults().align(0x1000000, 1).hint(-1, -1).grab(false, true).span(1, 5).indent(6, 6).applyTo((Control)imageLabel);
        Link link = new Link(composite, 0);
        link.setText(MessageFormat.format(this.errorMessage + "\n\nExchange is available at:\n<a href=\"{0}\">{1}</a>", PlatformUrls.getActiveExchangeUrl(), PlatformUrls.getActiveExchangeUrl()));
        GridDataFactory.fillDefaults().align(1, 1).hint(-1, -1).indent(6, 6).grab(false, false).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.text));
                }
                catch (Exception exception) {
                    MuleCorePlugin.logError((String)("Cannot open link " + event.text), (Throwable)exception);
                }
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 0x1000000;
        parent.setLayoutData((Object)gridData);
        this.createOkButton(parent, 0, "Ok", true);
    }

    protected Button createOkButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TemplatesRepositoryErrorDialog.this.okPressed();
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }
}

