/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.views;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.templatesrepo.Activator;
import org.osgi.framework.Bundle;

public class TemplatesImages {
    private static ImageRegistry registry = new ImageRegistry();
    private static final IPath ICONS_PATH = new Path("icons");
    public static final Image TEMPLATES_IMAGE = TemplatesImages.getManagedImage("exchange-icon.png");
    public static final Image TEMPLATES_STUDIO = TemplatesImages.getManagedImage("studio128x128.png");

    public static ImageDescriptor getManaged(String path) {
        IPath relPath = ICONS_PATH.append(path);
        ImageDescriptor desc = registry.getDescriptor(relPath.toString());
        if (desc == null) {
            desc = TemplatesImages.create(relPath);
            registry.put(relPath.toString(), desc);
        }
        return desc;
    }

    public static Image getManagedImage(String path) {
        IPath relPath = ICONS_PATH.append(path);
        Image image = registry.get(relPath.toString());
        if (image == null) {
            ImageDescriptor desc = TemplatesImages.getManaged(path);
            image = desc.createImage();
        }
        return image;
    }

    public static ImageDescriptor create(IPath path) {
        return TemplatesImages.createImageDescriptor(Activator.getDefault().getBundle(), path, true);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

