/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.views;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.templatesrepo.Activator;
import org.mule.tooling.templatesrepo.exceptions.MissingParameterException;
import org.mule.tooling.templatesrepo.exceptions.NoStudioUrlRegisteredException;
import org.mule.tooling.templatesrepo.urls.StudioUrl;
import org.mule.tooling.templatesrepo.urls.StudioUrlProviderManager;
import org.mule.tooling.templatesrepo.views.LibraryDialog;

public class TemplateLibraryDialog
extends LibraryDialog {
    protected boolean openInExternalBrowser = false;

    public TemplateLibraryDialog(Shell parentShell, String studioInfo, String url) {
        super(parentShell, studioInfo, url);
    }

    @Override
    protected void handleUrl(LocationEvent event) {
        try {
            String newUrl = event.location;
            StudioUrl studioUrl = StudioUrlProviderManager.getInstance().getStudioUrlParser().parseUrl(newUrl);
            if (studioUrl.isValidStudioUrl()) {
                event.doit = false;
                studioUrl.execute();
            }
        }
        catch (NoStudioUrlRegisteredException e) {
            event.doit = false;
            Activator.logError("Error while executing URL in Templates Repository", e);
            MessageDialog.openError((Shell)this.getBrowser().getComposite().getShell(), (String)"Error while trying to execute action", (String)"There was an error while executing the URL");
        }
        catch (MissingParameterException e) {
            event.doit = false;
            Activator.logError("Error while executing URL in Templates Repository", e);
            MessageDialog.openError((Shell)this.getBrowser().getComposite().getShell(), (String)"Error while trying to execute action", (String)"There was an error while executing the URL");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

