/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.views;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.browser.BrowserProxy;
import org.mule.tooling.browser.IBrowser;
import org.mule.tooling.templatesrepo.Activator;
import org.mule.tooling.templatesrepo.exceptions.MissingParameterException;
import org.mule.tooling.templatesrepo.exceptions.NoStudioUrlRegisteredException;
import org.mule.tooling.templatesrepo.urls.StudioUrl;
import org.mule.tooling.templatesrepo.urls.StudioUrlProviderManager;
import org.mule.tooling.ui.widgets.opal.InfiniteProgressPanel;

public class StudioBrowser {
    private static final String LOADING_LIBRARY_MESSAGE = "Loading Library...";
    protected IBrowser browser;
    protected boolean openInExternalBrowser = false;

    public StudioBrowser(Composite parent) {
        this.browser = this.createBrowser(parent);
    }

    public void setUrl(String url) {
        this.browser.addProgressListener(new ProgressListener(){
            private InfiniteProgressPanel progressPanel;

            public void completed(ProgressEvent event) {
                if (this.progressPanel != null) {
                    this.progressPanel.stop();
                    this.progressPanel = null;
                }
            }

            public void changed(ProgressEvent event) {
                if (this.progressPanel == null) {
                    this.progressPanel = InfiniteProgressPanel.getInfiniteProgressPanelFor((Shell)StudioBrowser.this.browser.getComposite().getShell());
                    this.progressPanel.setText(StudioBrowser.LOADING_LIBRARY_MESSAGE);
                    this.progressPanel.setLineLengthScale(0.25f);
                    this.progressPanel.start();
                }
            }
        });
    }

    protected IBrowser createBrowser(final Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        parent.setLayout((Layout)gridLayout);
        IBrowser browser = BrowserProxy.createBrowser((Composite)parent);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        browser.getComposite().setLayoutData((Object)data);
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                StudioBrowser.this.handleUrl(event);
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                parent.getShell().close();
            }
        });
        return browser;
    }

    protected boolean isWindows() {
        String osName = System.getProperty("os.name", "");
        return osName.startsWith("Windows");
    }

    protected void handleUrl(LocationEvent event) {
        try {
            String newUrl = event.location;
            StudioUrl studioUrl = StudioUrlProviderManager.getInstance().getStudioUrlParser().parseUrl(newUrl);
            if (studioUrl.isValidStudioUrl()) {
                event.doit = false;
                studioUrl.execute();
            }
        }
        catch (NoStudioUrlRegisteredException e) {
            event.doit = false;
            Activator.logError("Error while executing URL in Templates Repository", e);
            MessageDialog.openError((Shell)this.browser.getComposite().getShell(), (String)"Error while trying to execute action", (String)"There was an error while executing the URL");
        }
        catch (MissingParameterException e) {
            event.doit = false;
            Activator.logError("Error while executing URL in Templates Repository", e);
            MessageDialog.openError((Shell)this.browser.getComposite().getShell(), (String)"Error while trying to execute action", (String)"There was an error while executing the URL");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

