/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.views;

import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.browser.BrowserProxy;
import org.mule.tooling.browser.IBrowser;
import org.mule.tooling.core.utils.CoreUtils;

public class LibraryDialog
extends Dialog {
    protected static final double SCREEN_SIZE_PERCENTAGE = 0.8;
    public static final String TITLE = "Exchange";
    private IBrowser browser;
    private String ramlUrl;
    private String wsdlUrl;
    private String url;
    private String studioInfo;
    protected boolean openInExternalBrowser = false;
    private final Function<Object[], Object> setRamlUrl = arguments -> {
        String ramlUrl = (String)arguments[0];
        this.setRamlUrl(ramlUrl);
        this.close();
        if (this.getBrowser().getComposite() != null && !this.getBrowser().getComposite().isDisposed()) {
            this.getBrowser().getComposite().dispose();
        }
        return null;
    };
    private final Function<Object[], Object> setWsdlUrl = arguments -> {
        String wsdlUrl = (String)arguments[0];
        this.setWsdlUrl(wsdlUrl);
        this.close();
        if (this.getBrowser().getComposite() != null && !this.getBrowser().getComposite().isDisposed()) {
            this.getBrowser().getComposite().dispose();
        }
        return null;
    };
    private final Function<Object[], Object> reloadBrowserContent = arguments -> {
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)this.getBrowser().getComposite());
        this.browser.getComposite().setVisible(false);
        this.loadBrowserContent(this.browser.getComposite().getParent());
        return null;
    };

    public LibraryDialog(Shell parentShell, String studioInfo, String url) {
        super(parentShell);
        this.studioInfo = studioInfo;
        this.url = url;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        try {
            this.browser = BrowserProxy.createBrowser((Composite)composite);
            this.getBrowser().getComposite().setVisible(false);
            this.loadBrowserContent(composite);
            this.setTitle(TITLE);
        }
        catch (SWTError e) {
            this.showNoBrowserError(composite, e);
        }
        composite.getShell().setSize(this.getInitialSize());
        this.setDialogLocation();
        return composite;
    }

    private Point getDialogLocation() {
        Rectangle monitorArea = this.getShell().getDisplay().getPrimaryMonitor().getBounds();
        Rectangle shellArea = this.getShell().getBounds();
        int x = monitorArea.x + (monitorArea.width - shellArea.width) / 2;
        int y = monitorArea.y + (monitorArea.height - shellArea.height) / 2;
        return new Point(x, y);
    }

    private void setDialogLocation() {
        Point diagramLocation = this.getDialogLocation();
        this.getShell().setLocation(diagramLocation.x, diagramLocation.y);
    }

    protected Point getInitialSize() {
        Rectangle clientArea = this.getActiveClientArea();
        int repoWidth = (int)((double)clientArea.width * 0.8);
        int repoHeight = (int)((double)clientArea.height * 0.8);
        return new Point(repoWidth, repoHeight);
    }

    private Rectangle getActiveClientArea() {
        Monitor activeMonitor = this.getShell().getMonitor();
        Rectangle clientArea = activeMonitor.getClientArea();
        return clientArea;
    }

    private void showNoBrowserError(Composite parent, SWTError error) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Label noBrowserLabel = new Label(parent, 0x1000040);
        String errorMessage = "This dialog cannot be shown. An SWT error has ocurred (" + error.toString() + ").";
        if (SystemUtils.IS_OS_LINUX) {
            noBrowserLabel.setText(errorMessage + " Please install libwebkitgtk-1.0-0");
        } else {
            noBrowserLabel.setText(errorMessage);
        }
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)noBrowserLabel);
    }

    protected void loadBrowserContent(Composite parent) {
        this.layoutBrowser();
        this.browser.getComposite().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
            }

            public void changing(LocationEvent event) {
                LibraryDialog.this.handleUrl(event);
            }
        });
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                if (LibraryDialog.this.getShell() != null) {
                    LibraryDialog.this.getShell().close();
                }
            }
        });
        this.browser.addFunction("setRamlUrl", this.setRamlUrl);
        this.browser.addFunction("setWsdlUrl", this.setWsdlUrl);
        this.browser.addFunction("reloadBrowserContent", this.reloadBrowserContent);
        this.getShell().getDisplay().asyncExec(() -> {
            String studioId = CoreUtils.getStudioUniqueId();
            try {
                URL url = new URL(this.url);
                String cookieUrl = url.getProtocol() + "://" + url.getAuthority();
                BrowserProxy.setCookie((String)new HttpCookie("studio-id", studioId).toString(), (String)cookieUrl);
            }
            catch (MalformedURLException malformedURLException) {}
            this.browser.setUrl(this.url, this.studioInfo, new String[]{"User-Agent: studio", "Within-Tool: studio", "Content-Type: application/json", "X-Client-Id: " + studioId});
        });
    }

    private void layoutBrowser() {
        Composite browserComposite = this.browser.getComposite();
        Composite parent = browserComposite.getParent();
        browserComposite.setVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getBrowser().getComposite());
        parent.layout(true);
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle);
    }

    public String getRamlUrl() {
        return this.ramlUrl;
    }

    public void setRamlUrl(String ramlUrl) {
        this.ramlUrl = ramlUrl;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    void setWsdlUrl(String wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    protected void setTitle(String title) {
        this.getShell().setText(title);
    }

    public IBrowser getBrowser() {
        return this.browser;
    }

    protected void handleUrl(LocationEvent event) {
    }
}

