/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.utils;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.equinox.p2.metadata.Version;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.InstallationInformation;
import org.mule.tooling.templatesrepo.model.Connector;
import org.mule.tooling.templatesrepo.model.MuleRuntime;
import org.mule.tooling.templatesrepo.model.StudioInfo;

public class StudioInfoUtils {
    private static Set<MuleRuntime> installedRuntimes;
    private static Gson gson;

    static {
        gson = new GsonBuilder().create();
    }

    public static String getStudioInfoString(String perspective) {
        String studioInfo = gson.toJson((Object)StudioInfoUtils.getStudioInfo(perspective));
        return studioInfo;
    }

    public static StudioInfo getStudioInfo(String perspective) {
        StudioInfo studioInfo = new StudioInfo();
        studioInfo.setVersion(InstallationInformation.getStudioVersion());
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        studioInfo.setProjectOpen(muleProject != null);
        Set<Connector> inUseConnectors = muleProject != null ? StudioInfoUtils.getInUseConnectors(muleProject) : Collections.emptySet();
        studioInfo.setConnectors(inUseConnectors);
        studioInfo.setRuntimes(StudioInfoUtils.getInstalledRuntimes());
        studioInfo.setPerspective(perspective);
        return studioInfo;
    }

    private static Set<Connector> getInUseConnectors(IMuleProject muleProject) {
        return muleProject.getDeclaredExtensions().stream().map(ext -> {
            Connector connector = new Connector();
            connector.setId(ext.getQualifier());
            return connector;
        }).collect(Collectors.toSet());
    }

    private static Set<MuleRuntime> getInstalledRuntimes() {
        if (installedRuntimes == null) {
            HashSet runtimes = Sets.newHashSet();
            for (IServerDefinition serverDefinition : MuleCorePlugin.getServerManager().getServerDefinitions()) {
                MuleRuntime runtime = new MuleRuntime();
                runtime.setId(serverDefinition.getId());
                runtime.setLabel(serverDefinition.getLabel());
                runtime.setVersion(Version.create((String)serverDefinition.getVersion()));
                runtimes.add(runtime);
            }
            installedRuntimes = runtimes;
        }
        return installedRuntimes;
    }
}

