/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.urls;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.mule.tooling.templatesrepo.Activator;
import org.mule.tooling.templatesrepo.exceptions.NoStudioUrlRegisteredException;
import org.mule.tooling.templatesrepo.urls.StudioUrl;
import org.mule.tooling.templatesrepo.urls.StudioUrlDecodeHelper;
import org.mule.tooling.templatesrepo.urls.StudioUrlProvider;

public class StudioUrlParser {
    protected List<StudioUrlProvider> providers;

    public StudioUrlParser(List<StudioUrlProvider> providers) {
        this.providers = providers;
    }

    public StudioUrl parseUrl(String urlString) {
        URL url = this.createUrl(urlString);
        return this.createStudioUrl(url);
    }

    protected URL createUrl(String urlString) {
        if (urlString == null) {
            throw new NullPointerException("URL is null");
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        if (url.getProtocol() == null) {
            throw new IllegalArgumentException("URL protocol should not be null");
        }
        return url;
    }

    protected boolean isValidStudioUrl(URL url) {
        return this.isProtocolSupported(url) && this.isStudioHost(url);
    }

    protected boolean isStudioHost(URL url) {
        return url.getHost().equalsIgnoreCase("org.mule.tooling.templatesrepo");
    }

    protected boolean isProtocolSupported(URL url) {
        final String protocol = url.getProtocol();
        return Iterables.any(StudioUrl.STUDIO_COMMAND_PROTOCOLS, (Predicate)new Predicate<String>(){

            public boolean apply(String supportedProtocol) {
                return supportedProtocol.equalsIgnoreCase(protocol);
            }
        });
    }

    protected StudioUrl createStudioUrl(URL url) {
        if (this.isValidStudioUrl(url)) {
            String actionName = this.getPathAsAction(url);
            Properties parameters = this.getQueryParameters(url);
            StudioUrlProvider provider = this.findStudioUrlProviderFor(actionName);
            return provider.createStudioUrl(actionName, parameters);
        }
        return InvalidStudioUrl.getInstance();
    }

    protected StudioUrlProvider findStudioUrlProviderFor(final String actionName) {
        try {
            return (StudioUrlProvider)Iterables.find(this.providers, (Predicate)new Predicate<StudioUrlProvider>(){

                public boolean apply(StudioUrlProvider provider) {
                    return actionName.equals(provider.getActionName());
                }
            });
        }
        catch (NoSuchElementException e) {
            throw new NoStudioUrlRegisteredException("There is no provider registered for action name: " + actionName, e);
        }
    }

    private String getPathAsAction(URL url) {
        String path = url.getPath();
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        return path.substring(1);
    }

    public Properties getQueryParameters(URL url) {
        Properties properties = new Properties();
        String query = url.getQuery();
        if (query == null) {
            return properties;
        }
        String[] params = query.split("&");
        int i = 0;
        while (i < params.length) {
            String[] keyValuePair = params[i].split("=");
            if (keyValuePair.length != 2) {
                Activator.logWarning("Ignoring the following Intro URL parameter: " + params[i]);
            } else {
                String key = StudioUrlDecodeHelper.getInstance().urlDecode(keyValuePair[0]);
                if (key == null) {
                    Activator.logWarning("Failed to URL decode key: " + keyValuePair[0]);
                } else {
                    String value = StudioUrlDecodeHelper.getInstance().urlDecode(keyValuePair[1]);
                    if (value == null) {
                        Activator.logWarning("Failed to URL decode value: " + keyValuePair[1]);
                    } else {
                        properties.setProperty(key, value);
                    }
                }
            }
            ++i;
        }
        return properties;
    }

    private static class InvalidStudioUrl
    implements StudioUrl {
        private static final StudioUrl INSTANCE = new InvalidStudioUrl();

        public static StudioUrl getInstance() {
            return INSTANCE;
        }

        protected InvalidStudioUrl() {
        }

        @Override
        public boolean isValidStudioUrl() {
            return false;
        }

        @Override
        public void execute() {
        }
    }
}

