/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.urls;

import org.mule.tooling.templatesrepo.urls.IUrlEncoder;
import org.mule.tooling.templatesrepo.urls.NoEncoding;
import org.mule.tooling.templatesrepo.urls.UrlEncoder;

public class SearchInLibraryUrlBuilder {
    private static final String URL_SEPARATOR = "/";
    private static final String HASHBANG = "#!";
    private String baseUrl = "";
    private String searchTerm = "";
    private String tokenUrl = "";
    private IUrlEncoder encoder = new NoEncoding();

    public SearchInLibraryUrlBuilder addBuildUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        if (!baseUrl.contains(HASHBANG)) {
            this.baseUrl = baseUrl + (baseUrl.endsWith(URL_SEPARATOR) ? "#!/" : "/#!/");
        }
        return this;
    }

    public SearchInLibraryUrlBuilder addAccessToken(String accessToken) {
        if (accessToken != null) {
            this.encoder = new UrlEncoder();
            this.tokenUrl = "access_token=" + accessToken + "&token_type=bearer&state=";
        }
        return this;
    }

    public SearchInLibraryUrlBuilder addSearchTerm(String searchTerm) {
        if (searchTerm != null) {
            StringBuilder searchTermBuilder = new StringBuilder().append("?").append("searchTerm=").append(searchTerm);
            this.searchTerm = this.encoder.encode(searchTermBuilder.toString());
        }
        return this;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.baseUrl);
        builder.append(this.tokenUrl);
        builder.append(this.searchTerm);
        return builder.toString();
    }
}

