/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.urls;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectImportedFromUrlListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.StudioFileUtils;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.templatesrepo.Activator;
import org.mule.tooling.templatesrepo.editors.UiMuleProjectImportJob;
import org.mule.tooling.templatesrepo.exceptions.FileNotFound404Exception;
import org.mule.tooling.templatesrepo.urls.BaseStudioUrl;
import org.mule.tooling.templatesrepo.views.TemplatesRepositoryErrorDialog;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.io.ProgressTrackingInputStream;

public class OpenInStudioUrl
extends BaseStudioUrl {
    private static final String DOWNLOAD_PROJECT_TASK_NAME = "Downloading project";
    private static final String IMPORT_PROJECT_TASK_NAME = "Importing project to workbench";
    protected String url;
    protected String runtimeVersion;

    public OpenInStudioUrl(String url, String runtimeVersion) {
        this.url = url;
        this.runtimeVersion = runtimeVersion;
    }

    @Override
    public void execute() {
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            monitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DownloadAndImportProjectJob job = new DownloadAndImportProjectJob();
                    job.runInWorkspace(monitor);
                    OpenInStudioUrl.this.closeRepositoryView();
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable invocationTargetCause = e.getCause();
            if (invocationTargetCause instanceof WebApplicationException) {
                String errorMessage = "Open in Studio found an error while downloading the Template. Please make sure that your Internet connection is working properly.";
                Throwable clientHandlerCause = invocationTargetCause.getCause();
                if (clientHandlerCause instanceof IllegalArgumentException) {
                    errorMessage = "Open in Studio found an error while downloading the Template. The URL of the Template is not valid.";
                } else if (clientHandlerCause instanceof UnknownHostException) {
                    errorMessage = "Open in Studio found an error while downloading the Template. The file host could be currently down or your Internet connection may be down.";
                }
                new TemplatesRepositoryErrorDialog(Display.getCurrent().getActiveShell(), "Error while Opening Template in Studio", errorMessage).open();
            } else if (invocationTargetCause instanceof FileNotFound404Exception) {
                String errorMessage = MessageFormat.format("Resource not found at URL: {0}.\nPlease make sure that the requested resource exists and is accessible.", ((FileNotFound404Exception)invocationTargetCause).getUrl());
                new TemplatesRepositoryErrorDialog(Display.getCurrent().getActiveShell(), "Error while Opening Template in Studio", errorMessage).open();
            } else if (invocationTargetCause instanceof JobErrorStatusException) {
                new TemplatesRepositoryErrorDialog(Display.getCurrent().getActiveShell(), "Error while Opening Template in Studio", "There was an error unzipping the template ZIP file in Studio, the file may be corrupt, please retry downloading the template or contact your provider.").open();
            } else {
                Activator.logError("Error while downloading and importing project from repo", e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected JobChangeAdapter closeRepositoryViewOnJobDone() {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    OpenInStudioUrl.this.closeRepositoryView();
                }
            }
        };
    }

    private final class DownloadAndImportProjectJob
    extends WorkspaceJob {
        public DownloadAndImportProjectJob() {
            super("Download and Import project in Studio");
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            File file = null;
            try {
                monitor.beginTask("Opening in Studio...", 100);
                monitor.subTask(OpenInStudioUrl.DOWNLOAD_PROJECT_TASK_NAME);
                file = this.downloadProject((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)97));
                monitor.subTask(OpenInStudioUrl.IMPORT_PROJECT_TASK_NAME);
                this.importProject(file, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)3));
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(file);
                monitor.done();
                throw throwable;
            }
            FileUtils.deleteQuietly((File)file);
            monitor.done();
            return Status.OK_STATUS;
        }

        protected void importProject(File file, IProgressMonitor monitor) {
            try {
                try {
                    OpenInStudioUrl.this.validateCancel(monitor);
                    monitor.beginTask(OpenInStudioUrl.IMPORT_PROJECT_TASK_NAME, 1);
                    UiMuleProjectImportJob importProjectIntoWorkspaceJob = new UiMuleProjectImportJob(file, OpenInStudioUrl.this.runtimeVersion, true);
                    importProjectIntoWorkspaceJob.setProgressGroup(monitor, 1);
                    importProjectIntoWorkspaceJob.schedule();
                    importProjectIntoWorkspaceJob.join();
                    IStatus importResult = importProjectIntoWorkspaceJob.getResult();
                    if (!importResult.isOK()) {
                        if (importResult.getSeverity() == 8) {
                            throw new OperationCanceledException();
                        }
                        throw new JobErrorStatusException(importResult);
                    }
                    this.fireImportFromUrlNotification(this.getMuleProject(importProjectIntoWorkspaceJob.getSelectedProjectName()));
                    monitor.worked(1);
                }
                catch (InterruptedException e) {
                    Activator.logWarning(e.getMessage(), e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        private IMuleProject getMuleProject(String name) {
            IMuleProject[] iMuleProjectArray = MuleRuntime.getMuleProjects();
            int n = iMuleProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMuleProject muleProject = iMuleProjectArray[n2];
                if (muleProject.getName().equals(name)) {
                    return muleProject;
                }
                ++n2;
            }
            return null;
        }

        protected File downloadProject(IProgressMonitor progressMonitor) {
            OpenInStudioUrl.this.validateCancel(progressMonitor);
            try {
                Response response = ClientBuilder.newClient().target(OpenInStudioUrl.this.url).request().get();
                Response.Status responseStatus = Response.Status.fromStatusCode((int)response.getStatus());
                if (Response.Status.OK.equals((Object)responseStatus)) {
                    return this.doDownload(response, progressMonitor);
                }
                if (Response.Status.NOT_FOUND.equals((Object)responseStatus)) {
                    throw new FileNotFound404Exception(OpenInStudioUrl.this.url);
                }
                String message = MessageFormat.format("Received response {0} from url {1} with message {2}", responseStatus, OpenInStudioUrl.this.url, response.readEntity(String.class));
                throw new JobErrorStatusException((IStatus)new Status(4, "org.mule.tooling.templatesrepo", message));
            }
            catch (IOException iOException) {
                throw new JobErrorStatusException((IStatus)new Status(4, "org.mule.tooling.templatesrepo", "There was a problem downloading the template to a temporary directory"));
            }
        }

        private File doDownload(Response response, IProgressMonitor monitor) throws IOException {
            List list = (List)response.getStringHeaders().get((Object)"Content-Length");
            String contentLength = list != null && !list.isEmpty() ? (String)list.get(0) : null;
            int totalWork = StringUtils.isNotBlank(contentLength) ? Integer.valueOf(contentLength) : 100000;
            try {
                monitor.beginTask(OpenInStudioUrl.DOWNLOAD_PROJECT_TASK_NAME, totalWork);
                InputStream entityInputStream = (InputStream)response.readEntity(InputStream.class);
                File tempFile = StudioFileUtils.calculateTempPath((String)".jar".substring(1));
                FileUtils.copyInputStreamToFile((InputStream)new ProgressTrackingInputStream(entityInputStream, monitor), (File)tempFile);
                File file = tempFile;
                return file;
            }
            finally {
                monitor.done();
            }
        }

        private void fireImportFromUrlNotification(final IMuleProject project) {
            IMuleProjectModel muleProjectModel = project.getMuleProjectModel();
            AnalyticsRecordsFactory.single((String)Events.PROJECT_IMPORTED_FROM_URL, (String[])new String[]{"projectName", muleProjectModel.getName(), "projectArtifactId", muleProjectModel.getArtifactId(), "projectVersion", muleProjectModel.getVersion(), "projectGroupId", muleProjectModel.getGroupId()}).track();
            UtilsPlugin.getEventBus().fireEvent((IEvent)new IEvent<IMuleProjectImportedFromUrlListener>(){

                public EventType<IMuleProjectImportedFromUrlListener> getAssociatedType() {
                    return CoreEventTypes.ON_MULE_PROJECT_IMPORTED_FROM_URL;
                }

                public void dispatch(IMuleProjectImportedFromUrlListener handler) {
                    handler.onMuleProjectImportedFromUrl(project);
                }
            });
        }
    }

    public class JobErrorStatusException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final IStatus result;

        public JobErrorStatusException(IStatus result) {
            this.result = result;
        }

        public IStatus getResult() {
            return this.result;
        }
    }
}

