/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.urls;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.SingleExtensionCallback;
import org.mule.tooling.templatesrepo.urls.BaseStudioUrl;

public class InstallerStudioUrl
extends BaseStudioUrl {
    private static final String SUCCESS_TITLE = "Operation Successful";
    private static final String SUCCESS_MESSAGE = "The {0} has been successfully added to project \"{1}\"";
    private static final String CONFIRM_TITLE = "About to Add Connector";
    private static final String CONFIRM_MESSAGE = "This operation will add the selected connector to project \"{0}\".\nDo you wish to proceed?";
    private static final String[] LABELS = new String[]{"Proceed", "Cancel"};
    private final String coordinates;

    public InstallerStudioUrl(String coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public void execute() {
        Shell activeShell = Display.getDefault().getActiveShell();
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        MessageDialog messageDialog = new MessageDialog(activeShell, CONFIRM_TITLE, null, MessageFormat.format(CONFIRM_MESSAGE, muleProject.getLabel()), 2, LABELS, 0);
        int result = messageDialog.open();
        if (result == 0) {
            try {
                new ProgressMonitorDialog(activeShell).run(true, true, monitor -> this.doExecute(monitor));
            }
            catch (InterruptedException | InvocationTargetException e) {
                MuleCorePlugin.logError((String)("There was a problem adding " + this.coordinates + " to the current project"), (Throwable)e);
            }
        }
    }

    public void doExecute(IProgressMonitor monitor) {
        MavenDependency dependency;
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        if (!this.containsExtension(muleProject, dependency = MavenUtils.getPluginDependency((String)this.coordinates))) {
            ArtifactResolvingRunnerFactory.syncInstance().runResolvingExtension(muleProject, dependency, SingleExtensionCallback.builder().onSuccess(module -> {
                try {
                    muleProject.addMuleExtension(module);
                    this.showSuccess((ExternalContributionMuleModule)module, muleProject);
                }
                catch (CoreException e) {
                    this.showError(e);
                }
            }).onError(errors -> {
                CoreException exception = new CoreException((IStatus)new Status(4, "org.mule.tooling.templatesrepo", "An error occurred resolving " + this.coordinates + ": " + ArtifactResolvingRunnerFactory.getErrorsMessage((Map)errors)));
                this.showError(exception);
            }).build(), monitor);
        }
    }

    protected void showSuccess(ExternalContributionMuleModule module, IMuleProject muleProject) {
        this.closeRepositoryView();
        Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)SUCCESS_TITLE, (String)MessageFormat.format(SUCCESS_MESSAGE, module.getLabel(), muleProject.getLabel())));
    }

    private boolean containsExtension(IMuleProject muleProject, MavenDependency dependency) {
        return muleProject.getDeclaredExtensions().stream().map(MavenUtils::getDependency).anyMatch(dependency::equals);
    }

    protected void showError(CoreException e) {
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)("There was a problem adding " + this.coordinates), (String)e.getMessage()));
    }
}

