/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.urls;

import java.util.List;
import java.util.Properties;
import org.mule.tooling.templatesrepo.exceptions.IncorrectActionNameException;
import org.mule.tooling.templatesrepo.exceptions.MissingParameterException;
import org.mule.tooling.templatesrepo.urls.StudioUrl;
import org.mule.tooling.templatesrepo.urls.StudioUrlProvider;

public abstract class BaseStudioUrlProvider
implements StudioUrlProvider {
    protected abstract List<String> getRequiredParameterKeys();

    protected abstract StudioUrl doCreateStudioUrl(String var1, Properties var2);

    @Override
    public StudioUrl createStudioUrl(String actionName, Properties parameters) {
        this.validateActionName(actionName);
        this.validateParameters(parameters);
        return this.doCreateStudioUrl(actionName, parameters);
    }

    protected void validateActionName(String actionName) {
        if (!this.getActionName().equals(actionName)) {
            throw new IncorrectActionNameException(this.getActionName(), actionName);
        }
    }

    protected void validateParameters(Properties parameters) {
        List<String> keys = this.getRequiredParameterKeys();
        for (String key : keys) {
            if (parameters.containsKey(key)) continue;
            throw new MissingParameterException(key, this.getActionName());
        }
    }
}

