/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.urls;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;
import org.mule.tooling.templatesrepo.Activator;
import org.mule.tooling.templatesrepo.TemplatesRepository;
import org.mule.tooling.templatesrepo.urls.StudioUrl;
import org.mule.tooling.templatesrepo.utils.ProgressMonitorUtils;

public abstract class BaseStudioUrl
implements StudioUrl {
    @Override
    public boolean isValidStudioUrl() {
        return true;
    }

    protected void closeRepositoryView() {
        try {
            UIJob closeViewJob = new UIJob("Close Templates Repository View Job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        BaseStudioUrl.this.validateCancel(monitor);
                        monitor.beginTask("Closing Templates Repository", 1);
                        TemplatesRepository.getInstance().close();
                        monitor.worked(1);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            closeViewJob.schedule();
            closeViewJob.join();
        }
        catch (InterruptedException e) {
            Activator.logWarning(e.getMessage(), e);
        }
    }

    protected void validateCancel(IProgressMonitor monitor) {
        ProgressMonitorUtils.getInstance().validateCancel(monitor);
    }
}

