/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.templatesrepo.Activator;

public class TemplatesNightlyPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String PAGE_TITLE = "Exchange Settings";
    private static final String SEARCH_IN_EXCHANGE_TITLE = "Search in Exchange";
    private static final String DEPRECATED_LABEL = "Show deprecated assets";
    private static final String URL_LABEL = "URL";
    private static final String PUBLISH_API_SPEC_TO_EXCHANGE_MONITORING_TIMEOUT_LABEL = "Timeout to monitor the status of publishing an API Specification (in seconds)";

    public TemplatesNightlyPreferences() {
        super(1);
    }

    public void init(IWorkbench arg0) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Exchange configuration");
    }

    protected void createFieldEditors() {
        if (Activator.getDefault().isNightly()) {
            Group exchangeUIUrlGroup = new Group(this.getFieldEditorParent(), 32);
            exchangeUIUrlGroup.setText(PAGE_TITLE);
            StringFieldEditor url = new StringFieldEditor("url", URL_LABEL, (Composite)exchangeUIUrlGroup);
            GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)exchangeUIUrlGroup);
            GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)exchangeUIUrlGroup);
            this.addField((FieldEditor)url);
        }
        Group exchangeAssetGroup = new Group(this.getFieldEditorParent(), 32);
        exchangeAssetGroup.setText(SEARCH_IN_EXCHANGE_TITLE);
        BooleanFieldEditor showDeprecated = new BooleanFieldEditor("show.deprecated.asset", DEPRECATED_LABEL, (Composite)exchangeAssetGroup);
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).generateLayout((Composite)exchangeAssetGroup);
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)exchangeAssetGroup);
        this.addField((FieldEditor)showDeprecated);
        IntegerFieldEditor publishToExchangeTimeout = new IntegerFieldEditor("publish.api.spec.to.exchange.timeout", PUBLISH_API_SPEC_TO_EXCHANGE_MONITORING_TIMEOUT_LABEL, (Composite)exchangeAssetGroup);
        publishToExchangeTimeout.setValidRange(1, 3600);
        this.addField((FieldEditor)publishToExchangeTimeout);
    }
}

