/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.templatesrepo.editors;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.packageManager.MuleExportProperties;
import org.mule.tooling.core.packageManager.importing.CopyToWorkspaceAction;
import org.mule.tooling.core.packageManager.importing.LocateProjectsAction;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.ui.wizards.MuleProjectImportJob;

public class UiMuleProjectImportJob
extends UIJob {
    protected final File zipFile;
    private String runtimeVersion;
    protected final boolean useProjectNameFromMuleProjectXml;
    private String projectName;

    public UiMuleProjectImportJob(File zipFile, String runtimeVersion, boolean useProjectNameFromMuleProjectXml) {
        super("UI Mule Project Import Job");
        this.zipFile = zipFile;
        this.runtimeVersion = runtimeVersion;
        this.useProjectNameFromMuleProjectXml = useProjectNameFromMuleProjectXml;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            MuleProjectImportJob importProjectJob2;
            ExchangeProjectDownload download = new ExchangeProjectDownload(this.zipFile);
            download.validateProjectStructure();
            this.projectName = this.getProjectName(download, this.useProjectNameFromMuleProjectXml);
            switch (download.getStructureType()) {
                case EXPORTED: {
                    LocateProjectsAction action = new LocateProjectsAction(download.getZipFile(), ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
                    action.rename((String)action.getAvailableProjectNames().get(0), this.projectName);
                    importProjectJob2 = this.getImportJob((ProjectImportAction)action);
                    break;
                }
                case SOURCES: {
                    MuleProjectImportJob importProjectJob2 = this.getImportJob((ProjectImportAction)new CopyToWorkspaceAction(download.getExpandedRootFile(), this.projectName, true));
                }
                default: {
                    return Status.CANCEL_STATUS;
                }
            }
            importProjectJob2.schedule();
            importProjectJob2.join();
            return importProjectJob2.getResult();
        }
        catch (IOException iOException) {
            return new Status(4, "org.mule.tooling.templatesrepo", "Error while unzipping file");
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            return Status.CANCEL_STATUS;
        }
    }

    protected MuleProjectImportJob getImportJob(ProjectImportAction action) {
        return new MuleProjectImportJob(action, this.projectName, null);
    }

    protected String getProjectName(ExchangeProjectDownload download, boolean useProjectNameFromMuleProjectXml) throws IOException {
        String originalProjectName;
        String string = originalProjectName = useProjectNameFromMuleProjectXml ? download.getProjectName() : FilenameUtils.removeExtension((String)this.zipFile.getName());
        if (originalProjectName == null) {
            originalProjectName = FilenameUtils.removeExtension((String)this.zipFile.getName());
        }
        String projectName = UiMuleProjectImportJob.generateProjectNameFrom(originalProjectName);
        return projectName;
    }

    public String getSelectedProjectName() {
        return this.projectName;
    }

    protected static boolean isImportedRuntimeInstalled(final String runtimeId) {
        List serverDefinitions = MuleCorePlugin.getServerManager().getServerDefinitions();
        return Iterables.any((Iterable)serverDefinitions, (Predicate)new Predicate<IServerDefinition>(){

            public boolean apply(IServerDefinition serverDefinition) {
                return serverDefinition.getId().equalsIgnoreCase(runtimeId);
            }
        });
    }

    protected static String generateProjectNameFrom(String projectName) {
        projectName = ((String)projectName).replaceAll("[<>:\"/\\\\|?*]", "");
        String originalProjectName = projectName;
        File workspaceDir = CoreUtils.getWorkspaceLocation();
        int i = 0;
        while (new File(workspaceDir, (String)projectName).exists()) {
            projectName = originalProjectName + "-" + ++i;
        }
        return projectName;
    }

    private static class ExchangeProjectDownload {
        private File rootFile;
        private File zipFile;
        private StructureType structureType;

        public ExchangeProjectDownload(File zipFile) throws IOException {
            this.zipFile = zipFile;
            this.rootFile = this.unzipProject(zipFile);
        }

        public File getZipFile() {
            return this.zipFile;
        }

        public File getExpandedRootFile() {
            return this.rootFile;
        }

        protected File getProjectModelFile() {
            File projectModelFile = new File("");
            if (this.isExportedFile()) {
                File file = new File(new File(this.rootFile, "META-INF"), "mule-src");
                String[] list = file.list();
                if (list.length > 0) {
                    projectModelFile = new File(new File(file, list[0]), "pom.xml");
                }
            } else {
                projectModelFile = new File(this.rootFile, "pom.xml");
            }
            return projectModelFile;
        }

        public StructureType getStructureType() {
            if (this.structureType == null) {
                this.structureType = this.isExportedFile() ? (CoreUtils.hasExpectedProjectStructure((File)this.rootFile) ? StructureType.EXPORTED : StructureType.INVALID) : (CoreUtils.hasStudioWorkspaceProjectStructure((File)this.rootFile) ? StructureType.SOURCES : StructureType.INVALID);
            }
            return this.structureType;
        }

        protected boolean isExportedFile() {
            return new File(new File(this.rootFile, "META-INF"), "mule-src").exists();
        }

        public void validateProjectStructure() {
            if (this.getStructureType().equals((Object)StructureType.INVALID)) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Import failed", (String)"The project you are trying to import has an invalid folder structure. The operation cannot continue.");
                throw new OperationCanceledException();
            }
        }

        public String getSelectedRuntimeId() {
            File projectXmlFile = this.getProjectModelFile();
            if (projectXmlFile.exists()) {
                IServerDefinition serverDefinition = null;
                try {
                    IMuleProjectModel loadedProject = MuleResourceUtils.loadMuleProjectModel((File)projectXmlFile);
                    serverDefinition = MuleCorePlugin.getServerManager().getServerDefinition((String)loadedProject.getRuntimeQualifier().get());
                }
                catch (IOException e) {
                    MuleCorePlugin.logError((String)("Problem reading " + String.valueOf(projectXmlFile)), (Throwable)e);
                }
                return serverDefinition != null ? serverDefinition.getId() : null;
            }
            return null;
        }

        public String getProjectName() throws IOException {
            File projectXmlFile = this.getProjectModelFile();
            if (projectXmlFile.exists()) {
                IMuleProjectModel loadedProject = MuleResourceUtils.loadMuleProjectModel((File)projectXmlFile);
                return loadedProject.getName();
            }
            File exportPropertiesFile = new File(this.rootFile, "META-INF" + File.separator + "mule_export.properties");
            if (exportPropertiesFile.exists()) {
                MuleExportProperties muleExportProperties = MuleExportProperties.load((File)exportPropertiesFile);
                List exportedProjects = muleExportProperties.getExportedProjectsList();
                return (String)exportedProjects.get(0);
            }
            return null;
        }

        private File unzipProject(File file) throws IOException {
            File tempExpandedZipFile = CoreUtils.unzipFileToTemp((File)file);
            File[] listFiles = tempExpandedZipFile.listFiles();
            if (listFiles.length == 1 && listFiles[0].isDirectory() && !listFiles[0].getName().equals("META-INF")) {
                tempExpandedZipFile = listFiles[0];
            }
            return tempExpandedZipFile;
        }

        private static enum StructureType {
            INVALID,
            EXPORTED,
            SOURCES;

        }
    }
}

